/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * iseRegionSetFactoryHandler.hpp
 *
 *  Created on: Oct 7, 2010
 *      Author: vieux
 */

#ifndef ISEREGIONSETFACTORYHANDLER_HPP_
#define ISEREGIONSETFACTORYHANDLER_HPP_

#include <girl/girlCommon.hpp>
#include <girl/girlHashMap.hpp>
#include <girl/girlHashFunc.hpp>

#include "iseRegionSetAbstractFactory.hpp"
#include "iseRegionSetInterface.hpp"

namespace ise {
  /**
   * Magic class which register the region set factories
   * so that we can instantiate the right type or region
   * set at the good moment in the program. Classes which
   * need to instantiate region sets must only know about
   * this class.
   */
  class GIRL_API RegionSetFactoryHandler
  {

  public:

    static RegionSetFactoryHandler* instance();

    void addFactory(ise::RegionSetAbstractFactory*);

    void removeFactory(ise::RegionSetAbstractFactory*);

    /**
     * Create a new RegionSet with the right type, by using the
     * relevant factory
     */
    girl::shared_ptr<RegionSetInterface> newRegionSet(girl::shared_ptr<RegionFeatureComputer>);


  private:

    RegionSetFactoryHandler() {}

    typedef girl::hashMap<std::string, ise::RegionSetAbstractFactory*> FactoryContainer;

    FactoryContainer m_factories;

  };

}

#endif /* ISEREGIONSETFACTORYHANDLER_HPP_ */
