/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * iseRegionSetAbstractFactory.hpp
 *
 *  Created on: Oct 6, 2010
 *      Author: vieux
 */

#ifndef ISEREGIONSETABSTRACTFACTORY_HPP_
#define ISEREGIONSETABSTRACTFACTORY_HPP_

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp>

#include "iseRegionSetInterface.hpp"

namespace ise {

  class GIRL_API RegionSetAbstractFactory
  {

  public:

    virtual girl::shared_ptr<RegionSetInterface> newRegionSet(girl::shared_ptr<RegionFeatureComputer>) = 0;
    
    virtual const std::string uri() const = 0;

    virtual ~RegionSetAbstractFactory() {}

  };

}

#endif /* ISEREGIONSETABSTRACTFACTORY_HPP_ */
