/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONFEATURETEMPLATE_HXX
#define ISEREGIONFEATURETEMPLATE_HXX

#include <cstring>
#include <iostream>

#include <girl/girlCommon.hpp>


namespace ise {
//  class NormFunctor;
//  class DistanceFunctor;

/**
 * Base class for storing the region features. This is a template
 * class to facilitate change of feature type in the actual feature
 * storage class.
 *
 */
  template <typename T>
  class GIRL_API RegionFeatureTemplate
  {
  public:
    // REMI: REMOVED this constructor, coz we don't want the new to be performed
    // here, but let that to the memory manager @see iseRegionFeatureMemoryStorage
    // subclasses
//    explicit RegionFeatureTemplate(size_t size)
//    {
//      m_data = new T[size];
//      memset(m_data, 0, size*sizeof(T));
//    }

    /**
     * Constructor, DOES NOT take ownership of @a data
     * The caller is responsible for freeing the memory
     */
    explicit RegionFeatureTemplate(T* data) : m_data(data)
    {
    }

    ~RegionFeatureTemplate()
    {
      //delete [] m_data;
    }

    inline
    T* getData()
    {
      return m_data;
    }

    inline const
    T* getData() const
    {
      return m_data;
    }

    inline void
    copyTo(RegionFeatureTemplate &into, size_t size)
    {
      memcpy(into.m_data, m_data, size*sizeof(T));
    }

    /**
     * Warning: no out of boundary check is performed
     */
    inline const
    T& operator[](size_t i) const
    {
      return m_data[i];
    }

    inline
    T& operator[](size_t i)
    {
      return m_data[i];
    }

    std::ostream&
    print(std::ostream &out, size_t size)
    {
      for (size_t i = 0; i < size; ++i) {
        out << m_data[i] << " ";
      }
      out << std::endl;
      return out;
    }


  private:
    RegionFeatureTemplate(const RegionFeatureTemplate<T>&);
    RegionFeatureTemplate<T>& operator=(const RegionFeatureTemplate<T>&);


  protected:
    T* m_data;
  };

}
#endif /* ISEREGIONFEATURETEMPLATE_HXX */
