/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEREGIONFEATURESTORAGEHASH_HPP_
#define ISEREGIONFEATURESTORAGEHASH_HPP_

#include <girl/girlCommon.hpp>
#include <girl/girlHashMap.hpp>
#include <girl/girlHashFunc.hpp>

#include "iseRegionFeature.hpp"
#include "iseRegionFeatureAllocator.hpp"
#include "iseRegionSetInterface.hpp"
#include "iseRegionFeatureStorage.hpp"
/**
 * Implements a RegionFeatureStorage using a hash map
 */
namespace ise
{

  class RegionFeatureStorageHash : public ise::RegionFeatureStorage
  {
  public:
    explicit RegionFeatureStorageHash(RegionFeatureAllocator &allocator) :
      RegionFeatureStorage(allocator),
      m_map()
    {}

    virtual
    ~RegionFeatureStorageHash();

    inline bool
    exists(const girl::region &id) const
    {
      RFMap::const_iterator it = m_map.find(id);
      return it != m_map.end();
    }

    inline void
    get(const girl::region &id, ise::RegionFeature& feature, const size_t& dim) const
    {
      RFMap::const_iterator it = m_map.find(id);
      assert(it != m_map.end());
      it->second->copyTo(feature, dim);
    }

    inline void
    store(const girl::region& id, ise::RegionFeature* feature)
    {
      // REMI: TODO:UNSURE Shall we check that there is no feature already stored
      // for that region and delete them? Or is it performed above? Atm, 2nd solution
      m_map[id] = feature;
    }

    inline void
    erase(const girl::region &id)
    {
      RFMap::iterator it = m_map.find(id);
      assert(it != m_map.end());
      m_allocator.deallocate(it->second);
      m_map.erase(it);
    }

    inline void
    rename(const girl::region &oldId, const girl::region &newId)
    {
      RFMap::iterator it = m_map.find(oldId);
      assert(it != m_map.end());
      m_map[newId] = it->second;
      m_map.erase(it);
    }

    inline void
    merge(const girl::region &kept,
	  const girl::region &del,
	  ise::RegionSetInterface &regSet)
    {
      RFMap::iterator itKept = m_map.find(kept);
      RFMap::iterator itDel = m_map.find(del);
      assert(itKept != m_map.end());
      assert(itDel != m_map.end());
      regSet.mergeFeatures(*(itKept->second), *(itDel->second), kept, del);
    }

    inline void
    reset()
    {
      RFMap::iterator it = m_map.begin();
      RFMap::iterator itEnd = m_map.end();
      for ( ; it != itEnd; ++it) {
	m_allocator.deallocate(it->second);
      }
      m_map.clear();
    }


  protected:

    typedef girl::hashMap<girl::region, ise::RegionFeature*> RFMap;

    RFMap m_map;
  };

}

#endif /* ISEREGIONFEATURESTORAGEHASH_HPP_ */
