/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEREGIONFEATURESTORAGE_HPP_
#define ISEREGIONFEATURESTORAGE_HPP_

#include <girl/girlCommon.hpp>

#include "iseRegionFeature.hpp"
/**
 * Interface for all classes that implements a way of storing,
 * and retrieving of RegionFeatures.
 */

namespace ise
{

  class RegionSetInterface;
  class RegionFeatureAllocator;

  class GIRL_API RegionFeatureStorage
  {
  public:

    virtual ~RegionFeatureStorage() {}

    RegionFeatureStorage(RegionFeatureAllocator& allocator)
    : m_allocator(allocator) {}

    /**
     * Return true if feature for region @id is present in the storage,
     * false otherwise
     */
    virtual bool exists(const girl::region &id) const = 0;

    /**
     * Copy the region feature for region @id into @feature.
     * @dim dimension of the feature vector
     */
    virtual void get(const girl::region &id,
		     ise::RegionFeature& feature,
		     const size_t& dim) const = 0;

    /**
     * Store the features @feature corresponding to region @id for future reuse
     */
    virtual void store(const girl::region &id,
		       ise::RegionFeature* feature) = 0;

    /**
     * Delete the features for region @id
     */
    virtual void erase(const girl::region &id) = 0;

    /**
     * Rename region @oldId in @newId
     */
    virtual void rename(const girl::region &oldId,
			const girl::region &newId) = 0;

    /**
     * Merge features @deleted and @kept into @kept.
     * @computer the feature computer algorithm, which determines
     * how the merging is actually done
     */
    virtual void merge(const girl::region &kept,
		       const girl::region &deleted,
		       ise::RegionSetInterface &regSet) = 0;

    virtual void reset() = 0;

  protected:

    RegionFeatureAllocator &m_allocator;

  };


}

#endif /* ISEREGIONFEATURESTORAGE_HPP_ */
