/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
 * iseRegionFeatureSelector.hpp
 *
 *  Created on: Apr 14, 2011
 *      Author: vieux
 */

#ifndef ISEREGIONFEATURESELECTOR_HPP_
#define ISEREGIONFEATURESELECTOR_HPP_

/*
 *
 */

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp>
#include <girl/girlToger.hpp>

#include "iseRegionSetInterface.hpp"

namespace ise
{

  class GIRL_API RegionFeatureSelector
  {
  public:
    RegionFeatureSelector();
    virtual
    ~RegionFeatureSelector();

    /**
     * Copy features for regions @regs from @regSets into @selected according to @mask. @mask[i] == true
     * if feature must be copied, false otherwise. The ordering of the regSets matters
     * since mask is defined as with respect to the order the features are stored in
     * regSets
     */
    static void
    selectFeatures(const girl::regionDeque &regs, std::vector<girl::shared_ptr<RegionSetInterface> > &regSets,
        const std::vector<bool> &mask,
        cv::Mat &selected);
  };

}

#endif /* ISEREGIONFEATURESELECTOR_HPP_ */
