/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "iseRegionFeatureSelector.hpp"

#include <opencv2/core/core.hpp>


namespace ise
{
#ifndef NDEBUG
  static bool
  P_checkMatchDimensions(std::vector<girl::shared_ptr<RegionSetInterface> > &regSets,
      const std::vector<bool> &mask)
  {
    size_t dim = 0;
    for (size_t i = 0; i < regSets.size(); ++i) {
        dim += regSets[i]->getFeatureDim();
    }
    return dim == mask.size();
  }
#endif //NDEBUG

  RegionFeatureSelector::RegionFeatureSelector()
  {
  }

  RegionFeatureSelector::~RegionFeatureSelector()
  {
  }

  void
  RegionFeatureSelector::selectFeatures(const girl::regionDeque &regs,
      std::vector<girl::shared_ptr<RegionSetInterface> > &regSets,
      const std::vector<bool> &mask,
      cv::Mat &selected)
  {
    assert(P_checkMatchDimensions(regSets, mask));
    size_t totalDim = mask.size();
    size_t rows = regs.size();
    size_t cols = 0;
    std::vector<bool>::const_iterator bIt = mask.begin();
    const std::vector<bool>::const_iterator bItEnd = mask.end();
    for (; bIt != bItEnd; ++bIt)
      if (*bIt)
        cols++;

    selected = cv::Mat::zeros(rows, cols, CV_MAKETYPE(cv::DataDepth<RegionFeature_Data_Type>::value, 1));


    RegionFeature_Data_Type *buf = new RegionFeature_Data_Type[totalDim];

    girl::regionDeque::const_iterator rIt = regs.begin();
    const girl::regionDeque::const_iterator rItEnd = regs.end();
    for (size_t dataIndex = 0; rIt != rItEnd; ++rIt, ++dataIndex) {
        RegionFeature_Data_Type *toFill = selected.ptr<RegionFeature_Data_Type>(dataIndex);
        size_t index = 0;
        std::vector<girl::shared_ptr<RegionSetInterface> >::iterator regSetIt = regSets.begin();
        const std::vector<girl::shared_ptr<RegionSetInterface> >::iterator regSetItEnd = regSets.end();
        for (; regSetIt != regSetItEnd; ++regSetIt) {
            ise::RegionFeature rf(&buf[index]);
            (*regSetIt)->getRegionFeatures(*rIt, rf);
            // TODO:OPTIM invert regs/regSets loops?
            index += (*regSetIt)->getFeatureDim();
        }
        bIt = mask.begin();
        for (size_t i = 0; bIt != bItEnd; ++i, ++bIt) {
            if (*bIt) {
                *toFill++ = buf[i];
            }
        }
    }

    delete [] buf;
  }
}
