/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONFEATURECOMPUTER_HPP_
#define ISEREGIONFEATURECOMPUTER_HPP_

#include <cstring>
#include <sstream>
#include <string>
#include <vector>

#include <girl/girlSharedPtr.hpp>
#include <girl/girlToger.hpp>

#include "iseRegionFeature.hpp"

// R: DEPRECATED ??? (RegionSetInterface instead)
namespace ise
{

  class SegmentationContext;


  /**
   * Base class for all the extractors that compute characteristics
   * about single regions. Such extractors are called as delegates
   * from the RegionSet
   */

  class GIRL_API RegionFeatureComputer
  {


  public:

    RegionFeatureComputer(ise::SegmentationContext *sc) : m_segContext(sc)
      {}
    virtual
      ~RegionFeatureComputer() {}

    /**
     * @return a unique identifier of this feature computer
     */
    virtual const std::string uri() const = 0;

    /**
     * To be overloaded: return the size of the feature vector computed by the extractor
     */
    virtual size_t size() const = 0;

    /**
     * @return the type of the region set the feature computer fills in
     * (e.g. statistical, other)
     */
    //  virtual const std::string regSetType() const = 0;


    /**
     * Compute feature for the region @a id.
     */
    //  virtual RegionFeature* compute(const girl::toger &tog, girl::region id) = 0;
    /**
     * Compute the features for region @a id and store them in @a feature
     */
    virtual void
      compute(const girl::region &id,
	      ise::RegionFeature &feature) = 0;

    /**
     * Merge two region features. The actual merging is let to the concrete implementation,
     * since some features might be easily merged (e.g. added) while some cannot.
     * Implementation must guarantee that keptFeatures contains the merged features, whether
     * it is recomputed or added. If recomputed, it means that the regions have already been
     * merged in the toger, and we call compute using @a keptId
     */
    virtual void
      mergeFeatures(RegionFeature &keptFeatures,
		    RegionFeature& delFeatures,
		    const girl::region &keptId) = 0;


    /**
     * Return a description the current feature.
     * @param title is filled with the name of the feature
     * @param dimDesc is filled with a description of the semantics of each
     * dimension of the feature vector
     */
    void getFeatureDescription(std::string &title, std::vector<std::string>& dimDesc) const
    {
      getFeatureTitle(title);
      getFeatureDimDescription(dimDesc);
    }

    /**
     * @param title is filled with the name of the feature
     */
    virtual void getFeatureTitle(std::string &title) const = 0;

    /**
     * Return a semantic description of each dimension of the feature vector
     * REMI: DONE:REMOVED removed the default behavior, force re-implementation in
     * each feature computer otherwise, coder can forget and feature will be unusable
     * from GUI (or difficultly understandable)
     */
    virtual void getFeatureDimDescription(std::vector<std::string> &dimDesc) const = 0;
    //    {
    //      dimDesc.clear();
    //      for (size_t i = 0; i < size(); ++i) {
    //        std::stringstream ss(std::ios::in|std::ios::out);
    //        ss << "Dim " << i;
    //        dimDesc.push_back(ss.str());
    //      }
    //    }



  protected:

    ise::SegmentationContext *m_segContext;

  };
}

#endif /* ISEREGIONFEATURECOMPUTER_HPP_ */
