/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEREGIONFEATURECACHESTATENEVERSTORE_HPP_
#define ISEREGIONFEATURECACHESTATENEVERSTORE_HPP_

#include <girl/girlCommon.hpp>

#include "iseRegionFeatureCacheState.hpp"

/**
 * Implementation of RegionFeatureCacheState with no storage of feature
 * All operations but get are empty
 */

namespace ise
{
  class GIRL_API RegionFeatureCacheStateNeverStore : public ise::RegionFeatureCacheState
  {
  public:

    inline void
    getRegionFeatures(const girl::region& id,
        ise::RegionFeatureStorage*,
        ise::RegionSetInterface &regSet,
        ise::RegionFeatureAllocator*,
        ise::RegionFeature &feature)
    {
      regSet.compute(id, feature);
    }

    inline void
    insertRegion(const girl::region&,
            ise::RegionFeatureStorage*,
            ise::RegionSetInterface&,
            ise::RegionFeatureAllocator*)
    {}

    inline void replaceRegion(const girl::region &,
			      ise::RegionFeatureStorage *,
			       ise::RegionSetInterface &,
			       ise::RegionFeatureAllocator *)
    {}
 
    inline void
    deleteRegion(const girl::region&,
        ise::RegionFeatureStorage*)
    {}

    inline void
    renameRegion(const girl::region&,
        const girl::region&,
        ise::RegionFeatureStorage*)
    {}

    inline void
    mergeRegions(const girl::region&,
        const girl::region&,
        ise::RegionFeatureStorage*,
        ise::RegionSetInterface&)
    {}
  };
}



#endif /* ISEREGIONFEATURECACHESTATENEVERSTORE_HPP_ */
