/*
 * iseRegionFeatureCacheStateLazy.cpp
 *
 *  Created on: Nov 22, 2010
 *      Author: vieux
 */

#include "iseRegionFeatureCacheStateLazy.hpp"

#include "iseRegionSetInterface.hpp"

namespace ise {

  void
  RegionFeatureCacheStateLazy::getRegionFeatures(const girl::region &id,
      ise::RegionFeatureStorage* memStorage,
      ise::RegionSetInterface& regSet,
      ise::RegionFeatureAllocator* allocator,
      ise::RegionFeature &feature)
  {
    assert(memStorage);
    assert(allocator);
    if (memStorage->exists(id)) {
      memStorage->get(id, feature, regSet.getFeatureDim());
    } else {
      ise::RegionFeature *featureToStore = allocator->allocate(regSet.getFeatureDim());
      regSet.compute(id, *featureToStore);
      memStorage->store(id, featureToStore);
      featureToStore->copyTo(feature, regSet.getFeatureDim());
    }
  }


}
