/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEREGIONFEATURECACHESTATEALWAYSSTORE_HPP_
#define ISEREGIONFEATURECACHESTATEALWAYSSTORE_HPP_

#include <girl/girlCommon.hpp>

#include "iseRegionFeatureCacheState.hpp"

/**
 * Implementation of cache state where the features are always stored.
 *
 */
namespace ise {

  class GIRL_API RegionFeatureCacheStateAlwaysStore : public ise::RegionFeatureCacheState
  {

  public:

    //B:REFACTOR: these methods are virtual, inline keyword is useless !

    /**
     * Return the features which are always stored
     */
    inline void
    getRegionFeatures(const girl::region& id,
		      ise::RegionFeatureStorage* memStorage,
		      ise::RegionSetInterface& regSet,
		      ise::RegionFeatureAllocator*,
		      ise::RegionFeature& feature)
    {
      // TODO:OPTIM AlwaysStore the following assert should never happen
      assert(memStorage);
      assert(memStorage->exists(id));
      memStorage->get(id, feature, regSet.getFeatureDim());
    }

    //B:HACK
    void
      setRegionFeatures(const girl::region& id,
			ise::RegionFeatureStorage* memStorage,
			ise::RegionSetInterface& regSet,
			ise::RegionFeatureAllocator *allocator,
			ise::RegionFeature& feature)
    {
      // TODO:OPTIM AlwaysStore the following assert should never happen
      assert(memStorage);
      assert(memStorage->exists(id));
      //B:TODO:OPTIM: because interface of iseRFStorage is bad, we destroy and reallocate... otherwise we would leak...
      memStorage->erase(id);
      size_t dim = regSet.getFeatureDim();
      ise::RegionFeature *f = allocator->allocate(dim);
      for (size_t i=0; i<dim; ++i) 
	(*f)[i] = feature[i];
      memStorage->store(id, f);
    }


    /**
     * Always compute and store
     */
    inline void
    insertRegion(const girl::region& id,
		 ise::RegionFeatureStorage* memStorage,
		 ise::RegionSetInterface& regSet,
		 ise::RegionFeatureAllocator* allocator)
    {
      assert(memStorage);
      assert(allocator);
      ise::RegionFeature *feature = allocator->allocate(regSet.getFeatureDim());
      regSet.compute(id, *feature);
      memStorage->store(id, feature);
    }

    /**
     * If asserts are on, will check consistency before replacing the features,
     * i.e. region must be already in the memstorage
     */

    inline void 
    replaceRegion(const girl::region &id,
		  ise::RegionFeatureStorage *memStorage,
		  ise::RegionSetInterface &regSet,
		  ise::RegionFeatureAllocator *allocator)
    {
      assert(memStorage);
      assert(memStorage->exists(id));
      //B:TODO:OPTIM: we delete to recreate !???
      deleteRegion(id, memStorage);
      insertRegion(id, memStorage, regSet, allocator);
    }
    

    /**
     * In this mode, features should always be present
     */
    inline void
    deleteRegion(const girl::region &id,
        ise::RegionFeatureStorage* storage)
    {
      assert(storage);
      storage->erase(id);
    }

    /**
     * Always do the rename
     */
    inline void
    renameRegion(const girl::region& oldId,
        const girl::region& newId,
        ise::RegionFeatureStorage* storage)
    {
      assert(storage);
      storage->rename(oldId, newId);
    }

    /**
     * Always perform the merge
     */
    inline void
    mergeRegions(const girl::region& kept,
        const girl::region& del,
        ise::RegionFeatureStorage* storage,
        ise::RegionSetInterface& regSet)
    {
      assert(storage);
      storage->merge(kept, del, regSet);
    }

  };

}


#endif /* ISEREGIONFEATURECACHESTATEALWAYSSTORE_HPP_ */
