/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * RegionFeatureCacheState.hpp
 *
 *  Created on: Nov 18, 2010
 *      Author: vieux
 */

#ifndef ISEREGIONFEATURECACHESTATE_HPP_
#define ISEREGIONFEATURECACHESTATE_HPP_

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>

#include "iseRegionFeature.hpp"
#include "iseRegionFeatureAllocator.hpp"
#include "iseRegionFeatureComputer.hpp"
#include "iseRegionFeatureStorage.hpp"

/**
 * Interface for classes implementing a cache "state" for region features,
 * associated to a region set. Different cache state can be used,
 * e.g. storing all the region features, never store, lazy store... see
 * subclasses
 */
namespace ise
{

  class RegionSetInterface;

  class GIRL_API RegionFeatureCacheState
  {

  public:
    
    virtual ~RegionFeatureCacheState() {}

    /**
     * Get from the features associated with region @id.
     * @memStorage the object which concretely stores the features
     * @computer the algorithm which compute the feature (needed if
     * features are not stored)
     * @feature: output return a copy of the features for this region
     */
    virtual void getRegionFeatures(const girl::region& id,
        ise::RegionFeatureStorage* memStorage,
        ise::RegionSetInterface& regSet,
        ise::RegionFeatureAllocator* allocator,
        ise::RegionFeature& feature) = 0;


    //B:HACK
    virtual void
      setRegionFeatures(const girl::region& /*id*/,
			ise::RegionFeatureStorage* /*memStorage*/,
			ise::RegionSetInterface& /*regSet*/,
			ise::RegionFeatureAllocator*,
			ise::RegionFeature& /*feature*/) {} //B:HACK: only implemented for Always
    
    /**
     * Insert into the store @memStorage the region feature of region @id computed
     * by algorithm @computer
     * = new_region
     */
    virtual void insertRegion(const girl::region& id,
        ise::RegionFeatureStorage* memStorage,
        ise::RegionSetInterface& regSet,
        ise::RegionFeatureAllocator *allocator) = 0;


    /**
     * Replace in the store @memStorage the region feature of region @id by
     * the new features computed by algorithm @computer. The old region features
     * are deleted
     * = updateRegion
     */

    virtual void replaceRegion(const girl::region &id,
			       ise::RegionFeatureStorage *memStorage,
			       ise::RegionSetInterface &regSet,
			       ise::RegionFeatureAllocator *allocator) = 0;

    /**
     * Delete region @id from the storage @storage
     */
    virtual void deleteRegion(const girl::region &id,
        ise::RegionFeatureStorage* storage) = 0;

    /**
     * Rename region @oldId into @newId in the memory representation @storage
     */
    virtual void renameRegion(const girl::region& oldId,
        const girl::region& newId,
        ise::RegionFeatureStorage* storage) = 0;

    /**
     * Merge region features @keptReg and @delReg into @keptReg
     * @storage where the features are stored
     * @computer feature computer algorithm which does the actual merge
     */
    virtual void mergeRegions(const girl::region& keptReg,
        const girl::region& delReg,
        ise::RegionFeatureStorage* storage,
        ise::RegionSetInterface& regSet) = 0;


  };

}

#endif /* REGIONFEATURECACHESTATE_HPP_ */
