/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ISEREGIONFEATUREALLOCATORSTACK_HPP_
#define ISEREGIONFEATUREALLOCATORSTACK_HPP_

#include <cstring>
#include <girl/girlCommon.hpp>


#include "iseRegionFeature.hpp"
namespace ise {

  /**
 * Implementation of RegionFeatureAllocator which allocate RegionFeature
 * in the stack using new and delete[]
 */
  class GIRL_API RegionFeatureAllocatorStack : public RegionFeatureAllocator
  {
    inline RegionFeature*
    allocate(const size_t& size)
    {
      RegionFeature_Data_Type *data = new RegionFeature_Data_Type[size];
      memset(data, 0, size*sizeof(RegionFeature_Data_Type));
      RegionFeature *rf = new RegionFeature(data);
      return rf;
    }

    void
    deallocate(RegionFeature* rf)
    {
      delete [] rf->getData();
      delete rf;
    }
  };
}


#endif /* ISEREGIONFEATUREALLOCATORSTACK_HPP_ */
