/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ISEREGIONFEATUREALLOCATOR_HPP_
#define ISEREGIONFEATUREALLOCATOR_HPP_

#include <girl/girlCommon.hpp>

#include "iseRegionFeature.hpp"

namespace ise
{

  /**
   * Interface for all classes that handle the allocation/deallocation
   * of region features (e.g. new, memory pools, etc).
   */
  class GIRL_API RegionFeatureAllocator
  {
  public:
    virtual ~RegionFeatureAllocator() {}

    /**
     * Allocate a RegionFeature capable of storing a feature of dimension @size
     */
    virtual RegionFeature* allocate(const size_t& size) = 0;

    /**
     * Release the memory hold by the RegionFeature @a rf
     */
    virtual void deallocate(RegionFeature* rf) = 0;
  };

}


#endif /* ISEREGIONFEATUREALLOCATOR_HPP_ */
