/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONFEATURE_HPP_
#define ISEREGIONFEATURE_HPP_


#if 1

#include <girlTools/girlToolsImageFeature.hpp>
#include "iseRegionFeatureTemplate.hxx"

namespace ise {
/**
 * Actual class for storing feature. Features are stored as an array
 * of RegionFeature_Data_Type.
 *
 */
  typedef girl::tools::ImageFeature::type RegionFeature_Data_Type;
  typedef RegionFeatureTemplate<RegionFeature_Data_Type> RegionFeature;

}


#else
class RegionFeatureL1Norm;

namespace ise {
/**
 * Base class for storing the region features. This is a template
 * class to facilitate change of feature type in the actual feature
 * storage class.
 *
 */
  class GIRL_API RegionFeature
  {
  public:
    explicit RegionFeature(size_t size)
    {
      m_data = new double[size];
      memset(m_data, 0, size*sizeof(double));
    }

    ~RegionFeature()
    {
      delete [] m_data;
    }

    /**
     * Warning: no out of boundary check is performed
     */
    const double& operator[](size_t i) const
    {
      return m_data[i];
    }

    double& operator[](size_t i)
    {
      return m_data[i];
    }

    double
    norm(RegionFeatureL1Norm& f)
    {
      return f(*this);
    }

    std::ostream&
    print(std::ostream &out, size_t size)
    {
      for (size_t i = 0; i < size; ++i) {
        out << m_data[i] << " ";
      }
      out << std::endl;
      return out;
    }

  private:
    RegionFeature(const RegionFeature&);
    RegionFeature& operator=(const RegionFeature&);


  protected:
    double* m_data;
  };


#endif
#endif /* ISEREGIONFEATURE_HPP_ */
