/*
  Colorimetric moments feature for a region.
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef REGIONCOLORIMETRICFEATURES_HPP
#define REGIONCOLORIMETRICFEATURES_HPP

#include <cstring> //memcpy

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>

#include "iseFlt3Tools.hpp"

namespace ise {
  
  class GIRL_API RegionColorimetricFeatures
  {

  public:

    //RegionColorimetricFeatures(girl::region id, double m0, girl::tools::Flt3 m1, girl::tools::Flt3 m2);
    RegionColorimetricFeatures(girl::region id, double m0, const double *m1, const double *m2, size_t size)
      : regId(id)
      , m_m0(m0)
      , m_m1(NULL)
      , m_m2(NULL)
      , m_size(size)
      {
	m_m1 = new double[size];
	m_m2 = new double[size];
	memcpy(m_m1, m1, size*sizeof(double));
	memcpy(m_m2, m2, size*sizeof(double));
    }

    //B:
    RegionColorimetricFeatures(const RegionColorimetricFeatures &copy)
      : regId(copy.regId)
      , m_m0(copy.m_m0)
      , m_m1(NULL)
      , m_m2(NULL)
      , m_size(copy.m_size)
      {
	m_m1 = new double[m_size];
	m_m2 = new double[m_size];
	memcpy(m_m1, copy.m_m1, m_size*sizeof(double));
	memcpy(m_m2, copy.m_m2, m_size*sizeof(double));	
      }
    
    //B:
    RegionColorimetricFeatures &operator=(const RegionColorimetricFeatures &copy)
      {
	if (&copy != this) {
	  regId = copy.regId;
	  m_m0 = copy.m_m0;
	  m_size = copy.m_size;
	  m_m1 = new double[m_size];
	  m_m2 = new double[m_size];
	  memcpy(m_m1, copy.m_m1, m_size*sizeof(double));
	  memcpy(m_m2, copy.m_m2, m_size*sizeof(double));	
	}
	return *this;
      }
    
    //RegionColorimetricFeatures(const RegionColorimetricFeatures *copy);
    explicit RegionColorimetricFeatures(const RegionColorimetricFeatures *copy)
      : regId(copy->regId)
      , m_m0(copy->m_m0)
      , m_m1(NULL)
      , m_m2(NULL)
      , m_size(copy->m_size)
      {
	m_m1 = new double[m_size];
	m_m2 = new double[m_size];
	memcpy(m_m1, copy->m_m1, m_size*sizeof(double));
	memcpy(m_m2, copy->m_m2, m_size*sizeof(double));	
      }

    ~RegionColorimetricFeatures()
      {
	delete[] m_m1;
	delete[] m_m2;
      }
  
    inline double getArea() const { return m_m0; }
 
    //inline girl::tools::Flt3 getMean() const { return m_m1 * (1.0 / m_m0); }
    inline void getMean(double *v) const { 
      double val;
      if (m_m0 > 0)
	val = 1.0 / m_m0;
      else
	val = 1;

      for (size_t i = 0 ; i < m_size ; ++i)
	v[i] = m_m1[i] * val;
    }
  
    //inline girl::tools::Flt3 getMoment1() const { return m_m1; }
    inline double *getMoment1() const { return m_m1; }
  
    //inline girl::tools::Flt3 getMoment2() const { return m_m2; }
    inline double *getMoment2() const { return m_m2; }

    inline girl::region getGirlId() const { return regId; } //B:debug

    inline size_t getSize() const { return m_size; }

    double getSQE();
  
    double getMeanSQE();
  
    void merge2RegionFeatures(RegionColorimetricFeatures *reg);
  
    double computeMergingSqeMean(RegionColorimetricFeatures *reg1, RegionColorimetricFeatures *reg2);

  private:

    girl::region regId;

    /*double m_m0;
    girl::tools::Flt3 m_m1;
    girl::tools::Flt3 m_m2;*/

    double m_m0;
    double *m_m1;
    double *m_m2;

    size_t m_size;
  };

}

#endif /* !REGIONCOLORIMETRICFEATURES_HPP */
