/*
  Colorimetric moments feature for a region.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <cassert>
#include <cmath>

#include "iseStat.hpp"
#include "iseRegionColorimetricFeatures.hpp"

using namespace ise;

/*
RegionColorimetricFeatures::RegionColorimetricFeatures(girl::region id, 
						       double M0, 
						       girl::tools::Flt3 M1, 
						       girl::tools::Flt3 M2) :
  regId(id),
  m_m0(M0),
  m_m1(M1),
  m_m2(M2)
{

}

RegionColorimetricFeatures::RegionColorimetricFeatures(const RegionColorimetricFeatures *copy) :
  regId(copy->regId), 
  m_m0(copy->m_m0), 
  m_m1(copy->m_m1),
  m_m2(copy->m_m2)
{

}
*/
double 
RegionColorimetricFeatures::getSQE()
{
  /*
  const double invM0 = 1.0 / m_m0;
  const double sm2 = m_m2[0] +  m_m2[1] +  m_m2[2];
  const double sm1s = m_m1[0]*m_m1[0] + m_m1[1]*m_m1[1] + m_m1[2]*m_m1[2];
  return (sm2 - sm1s*invM0);
  */

  return iseStat_iseComputeSQE(m_m0, m_m1, m_m2, m_size);

}

double
RegionColorimetricFeatures::getMeanSQE()
{
  /*
  const double invM0 = 1.0 / m_m0;
  const double sm2 = m_m2[0] +  m_m2[1] +  m_m2[2];
  const double sm1s = m_m1[0]*m_m1[0] + m_m1[1]*m_m1[1] + m_m1[2]*m_m1[2];
  return (sm2 - sm1s*invM0)*invM0;
  */

  return iseStat_iseComputeVariance(m_m0, m_m1, m_m2, m_size);
}

void
RegionColorimetricFeatures::merge2RegionFeatures(RegionColorimetricFeatures *reg)
{
  assert(reg);
  assert( m_size == reg->getSize() );

  m_m0 += reg->m_m0;
  //m_m1 += reg->m_m1;
  //m_m2 += reg->m_m2;

  iseDouble_addition(m_m1, reg->m_m1, m_size);
  iseDouble_addition(m_m2, reg->m_m2, m_size);
}

double
RegionColorimetricFeatures::computeMergingSqeMean(RegionColorimetricFeatures *reg1, RegionColorimetricFeatures *reg2)
{
  assert(reg1);
  assert(reg2);

  assert( reg1->getSize() == reg2->getSize() );

  double sqe1 = reg1->getSQE();
  double sqe2 = reg2->getSQE();

  const double m01 = reg1->m_m0;
  const double m02 = reg2->m_m0;
  assert(fabs(m01 + m02) > 0.0000001);
  const double alpha = (m01 * m02) / (m01 + m02);
  
  //return sqe1 + sqe2 + alpha * iseFlt3_dist(reg1->m_m1, reg2->m_m2);
  return sqe1 + sqe2 + alpha * iseDouble_dist(reg1->m_m1, reg2->m_m2, reg1->getSize());
}
