/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
 * iseRegionBinaryPredicateTrue.hpp
 *
 *  Created on: Oct 14, 2010
 *      Author: vieux
 */

#ifndef ISEREGIONBINARYPREDICATETRUE_HPP_
#define ISEREGIONBINARYPREDICATETRUE_HPP_

#include "iseFactoryTemplate.hxx"
#include "iseRegionBinaryPredicate.hpp"

namespace ise
{
  /**
   * Implements a basic RegionBinaryPredicate that always return true
   */
  class GIRL_API RegionBinaryPredicateTrue : public RegionBinaryPredicate
  {

  public:

    explicit RegionBinaryPredicateTrue(ise::SegmentationContext *segContext = NULL) : RegionBinaryPredicate(segContext) {}
    /**
     * @brief Constructor
     */

    /**
     * @brief operator()
     * @return always return true
     */
    virtual RegionBinaryPredicate::result_type
    operator()(const RegionBinaryPredicate::first_argument_type&,
               const RegionBinaryPredicate::second_argument_type&)
    {
      return true;
    }
/*
    */
  };
  typedef FactoryTemplate<RegionBinaryPredicate, RegionBinaryPredicateTrue> RegionBinaryPredicateTrueFactory;

}

#endif /* ISEREGIONBINARYPREDICATETRUE_HPP_ */
