/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONBINARYPREDICATETHRESHOLD_HPP_
#define ISEREGIONBINARYPREDICATETHRESHOLD_HPP_

#include "iseFactoryTemplate.hxx"
#include "iseRegionBinaryPredicate.hpp"
#include "iseRegionBinaryFunction.hpp"
#include "iseComparisonFunction.hpp"

namespace ise
{
  /**
   * Implements a RegionBinaryPredicate that compare the result of a RegionBinaryFunction to a threshold.
   */
  class GIRL_API RegionBinaryPredicateThreshold : public RegionBinaryPredicate
  {
    
  public:
    
    typedef girl::shared_ptr<RegionBinaryFunction> BinaryFctPtr;
    
    /**
     * @brief Constructor
     */
    RegionBinaryPredicateThreshold(ise::SegmentationContext *segContext)
      : RegionBinaryPredicate(segContext),
      m_binaryFct(),
      m_comp(ise::LESS),
      m_threshold(0.3)
	{}
    
    void setRegionBinaryFunction(BinaryFctPtr f)
    {
      m_binaryFct = f;
    }
    
    BinaryFctPtr getRegionBinaryFunction() const
    {
      return m_binaryFct;
    }
    
    void setComparisonOperator(ComparisonOperator c)
    {
      m_comp = c;
    }
    
    ComparisonOperator getComparisonOperator() const
    {
      return m_comp;
    }
    
    
    void setThreshold(double threshold)
    {
      m_threshold = threshold;
    }
    
    double getThreshold() const
    {
      return m_threshold;
    }
    
    RegionBinaryPredicate::result_type
      operator()(const RegionBinaryPredicate::first_argument_type &r1,
		 const RegionBinaryPredicate::second_argument_type &r2)
    {
      return (ise::getComparisonFunction(m_comp))((*m_binaryFct)(r1, r2), m_threshold);
    }
    
  protected:
    
    
  protected:
    BinaryFctPtr m_binaryFct;
    ComparisonOperator m_comp;
    double m_threshold;
  };
  
  typedef FactoryTemplate<RegionBinaryPredicate, RegionBinaryPredicateThreshold> RegionBinaryPredicateThresholdFactory;
  
}

#endif /* ISEREGIONBINARYPREDICATETHRESHOLD_HPP_ */
