/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONBINARYPREDICATEFROMUNARYPREDICATE_HPP_
#define ISEREGIONBINARYPREDICATEFROMUNARYPREDICATE_HPP_

#include "iseFactoryTemplate.hxx"
#include "iseRegionBinaryPredicate.hpp"
#include "iseRegionUnaryPredicate.hpp"


namespace ise
{
  /**
   * Implements a RegionBinaryPredicate that uses a RegionUnaryPredicate on one of the two regions.
   */
  class GIRL_API RegionBinaryPredicateFromUnaryPredicate : public RegionBinaryPredicate
  {
    
  public:
    
    typedef girl::shared_ptr<RegionUnaryPredicate> UnaryPredPtr;
    
    /**
     * @brief Constructor
     */
    explicit RegionBinaryPredicateFromUnaryPredicate(ise::SegmentationContext *segContext)
      : RegionBinaryPredicate(segContext),
      m_unaryPred(),
      m_selectedRegion(0)
	{}
    
    void setRegionUnaryPredicate(UnaryPredPtr f)
    {
      m_unaryPred = f;
    }
    
    UnaryPredPtr getRegionUnaryPredicate() const
    {
      return m_unaryPred;
    }
    
    void setSelectedRegion(int i)
    {
      m_selectedRegion = (i==0) ? 0 : 1;
    }
    
    int getSelectedRegion() const
    {
      return m_selectedRegion;
    }
    
    RegionBinaryPredicate::result_type
      operator()(const RegionBinaryPredicate::first_argument_type &r1,
		 const RegionBinaryPredicate::second_argument_type &r2)
    {
      if (m_selectedRegion)
	return (*m_unaryPred)(r2);
      else 
	return (*m_unaryPred)(r1);
    }
    
  protected:
    
    
  protected:
    UnaryPredPtr m_unaryPred;
    int m_selectedRegion;
  };
  
  typedef FactoryTemplate<RegionBinaryPredicate, RegionBinaryPredicateFromUnaryPredicate> RegionBinaryPredicateFromUnaryPredicateFactory;
  
}

#endif /* ISEREGIONBINARYPREDICATEFROMUNARYPREDICATE_HPP_ */
