/*
  Copyright (C) 2005-2012 Jean-Philippe Domenger, Boris Mansencal, Remi Vieux remi.vieux@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ISEREGIONBINARYPREDICATEFROMUNARYFUNCTION_HPP
#define ISEREGIONBINARYPREDICATEFROMUNARYFUNCTION_HPP


#include "iseFactoryTemplate.hxx"
#include "iseRegionBinaryPredicate.hpp"
#include "iseRegionUnaryFunction.hpp"
#include "iseComparisonFunction.hpp"

namespace ise
{

  /**
   * Implements a RegionBinaryPredicate that compares the result of RegionUnaryFunctions
   */
class GIRL_API RegionBinaryPredicateFromUnaryFunction : public RegionBinaryPredicate
{

public:
 typedef girl::shared_ptr<RegionUnaryFunction> UnaryFunctionPtr;


public:


    explicit RegionBinaryPredicateFromUnaryFunction(ise::SegmentationContext *segContext);


    void setRegionUnaryFunction(UnaryFunctionPtr f)
    {
      m_unaryFct = f;
    }

    UnaryFunctionPtr getRegionUnaryFunction() const
    {
      return m_unaryFct;
    }

    void setComparisonOperator(ComparisonOperator c)
    {
      m_comp = c;
    }

    ComparisonOperator getComparisonOperator() const
    {
      return m_comp;
    }



    RegionBinaryPredicate::result_type
      operator()(const RegionBinaryPredicate::first_argument_type &r1,
                 const RegionBinaryPredicate::second_argument_type &r2)
    {
      return (ise::getComparisonFunction(m_comp))((*m_unaryFct)(r1), (*m_unaryFct)(r2));
    }

  protected:


  protected:
    UnaryFunctionPtr m_unaryFct;
    ComparisonOperator m_comp;

};

typedef FactoryTemplate<RegionBinaryPredicate, RegionBinaryPredicateFromUnaryFunction> RegionBinaryPredicateFromUnaryFunctionFactory;

}

#endif // ISEREGIONBINARYPREDICATEFROMUNARYFUNCTION_HPP
