/*
  Copyright (C) 2012 Jean-Philippe Domenger, Boris Mansencal boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseRegionBinaryPredicateBoolCombine.hpp"

namespace ise {

  namespace {
    
    bool P_and(bool b1, bool b2) { return b1 && b2; }

    bool P_or(bool b1, bool b2) { return b1 || b2; }
    
  } //end anonymous namespace

  RegionBinaryPredicateBoolCombine::BoolFunction 
  RegionBinaryPredicateBoolCombine::getBoolFunction(BoolOperator o)
  {
    if (o == AND)
      return P_and;
    else
      return P_or;
  }
    
  RegionBinaryPredicateBoolCombine::BoolOperator 
  RegionBinaryPredicateBoolCombine::getBoolOperatorFromFunction(BoolFunction f)
  {
    if (f == P_and)
      return AND;
    else if (f == P_or)
      return OR;
    return AND;
  }




}
