/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEREGIONBINARYFUNCTIONWITHREGSETEUCLIDEANDISTANCE_HPP_
#define ISEREGIONBINARYFUNCTIONWITHREGSETEUCLIDEANDISTANCE_HPP_

#include <girl/girlCommon.hpp>

#include "iseFactoryTemplate.hxx"
#include "iseRegionBinaryFunctionWithRegSet.hpp"

/**
 * Return the L2 distance between the region feature
 *
 */
namespace ise {
  class GIRL_API RegionBinaryFunctionWithRegSetEuclideanDistance : public RegionBinaryFunctionWithRegSet
  {
  public:

    /**
     * Constructor
     */
    explicit RegionBinaryFunctionWithRegSetEuclideanDistance(ise::SegmentationContext *segContext)
    : RegionBinaryFunctionWithRegSet(segContext) {}

    virtual
    ~RegionBinaryFunctionWithRegSetEuclideanDistance() {}

    result_type
    operator()(const first_argument_type & reg1,
        const second_argument_type& reg2);
  };

  typedef FactoryTemplate<RegionBinaryFunction, RegionBinaryFunctionWithRegSetEuclideanDistance> RegionBinaryFunctionWithRegSetEuclideanDistanceFactory;

}
#endif /* ISEREGIONBINARYFUNCTIONWITHREGSETEUCLIDEANDISTANCE_HPP_ */
