/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "iseRegionBinaryFunctionWithRegSetEuclideanDistance.hpp"
#include <iostream>

#include <opencv2/flann/flann.hpp>

namespace ise
{
  RegionBinaryFunction::result_type
  RegionBinaryFunctionWithRegSetEuclideanDistance::operator()(const first_argument_type & reg1,
							      const second_argument_type& reg2)
  {
    assert(m_regSet);
    assert(m_memory1);
    assert(m_memory2);
    RegionFeature rf1(m_memory1);
    RegionFeature rf2(m_memory2);
    m_regSet->getRegionFeatures(reg1, rf1);
    m_regSet->getRegionFeatures(reg2, rf2);
#if CV_MAJOR_VERSION*100+CV_MINOR_VERSION*10+CV_SUBMINOR_VERSION < 231
    return cvflann::euclidean_dist(m_memory1, m_memory1 + m_regSet->getFeatureDim(), m_memory2);
#else
    return cvflann::L2<ise::RegionFeature_Data_Type>()(m_memory1, m_memory2, m_regSet->getFeatureDim());
#endif
  }



} //end namespace ise
