/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONBINARYFUNCTIONCONSTANTNULL_HPP_
#define ISEREGIONBINARYFUNCTIONCONSTANTNULL_HPP_

#include "iseRegionBinaryFunction.hpp"
#include "iseFactoryTemplate.hxx"

namespace ise
{

  class GIRL_API RegionBinaryFunctionConstantNull : public RegionBinaryFunction
  {
  public:

    RegionBinaryFunctionConstantNull(ise::SegmentationContext *segContext)
      : RegionBinaryFunction(segContext)
      {}
  
    virtual result_type operator()(const first_argument_type & ,
				   const second_argument_type& )
    {
      return 0;
    }
    
  };

  typedef FactoryTemplate<RegionBinaryFunction, RegionBinaryFunctionConstantNull> RegionBinaryFunctionConstantNullFactory;

}

#endif /* ISEREGIONBINARYFUNCTIONCONSTANTNULL_HPP_ */
