/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONBINARYFUNCTIONCOMMONBOUNDARYTANGENTVARIANCE_HPP_
#define ISEREGIONBINARYFUNCTIONCOMMONBOUNDARYTANGENTVARIANCE_HPP_

#include "iseFactoryTemplate.hxx"
#include "iseRegionBinaryFunction.hpp"
#include "iseRegionTools.hpp"
#include "iseSegmentationContext.hpp"

namespace ise
{

  /**
   * Implementation of a RegionBinaryFunction
   * Computes the variance of the tangent on the common boundary
   */

  class GIRL_API RegionBinaryFunctionCommonBoundaryTangentVariance : public RegionBinaryFunction
  {

  public:

    /**
     * Constructor
     */
    RegionBinaryFunctionCommonBoundaryTangentVariance(ise::SegmentationContext *segContext)
      : RegionBinaryFunction(segContext)
      {}

    /**
     * @return the tangent variance on the region common boundary
     */
    inline RegionBinaryFunction::result_type
      operator ()(const RegionBinaryFunction::first_argument_type &reg1,
		  const RegionBinaryFunction::second_argument_type &reg2)
    {
      assert(m_segContext);
      assert(m_segContext->getToger());
      return ise::RegionTools_computeTangentVarianceOnCommonBoundary(*(m_segContext->getToger()),
								   reg1, reg2);
    }

  protected:
    
  };


  typedef FactoryTemplate<RegionBinaryFunction, RegionBinaryFunctionCommonBoundaryTangentVariance> RegionBinaryFunctionCommonBoundaryTangentVarianceFactory;
}

#endif /* ISEREGIONBINARYFUNCTIONCOMMONBOUNDARYTANGENTVARIANCE_HPP_ */
