/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONBINARYFUNCTION_HPP_
#define ISEREGIONBINARYFUNCTION_HPP_

#include <functional>

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>

#include "iseAbstractFactoryTemplate.hxx"
#include "iseRegionFeature.hpp"

namespace ise
{
  /**
   * Interface for all the functions whose definition domain is two regions
   * and that return a real, e.g. eval functions.
   * Operator() must be subclassed to do the actual computation of the
   * function
   * By subclassing std::binary_function, three typedefs are created:
   * RegionUnaryFunction::result_type which is of type RegionFeature_Data_type(currently double)
   * RegionUnaryFunction::first_argument_type which is a girl::region
   * RegionUnaryFunction::second_argument_type which is a girl::region
   */
  class GIRL_API RegionBinaryFunction :
    public std::binary_function<girl::region, girl::region, RegionFeature_Data_Type>
  {
  public:

    RegionBinaryFunction(ise::SegmentationContext *segContext)
      : m_segContext(segContext)
      {}
  
    virtual ~RegionBinaryFunction() {}
  
    virtual result_type operator()(const first_argument_type & reg1,
				   const second_argument_type& reg2) = 0;

  protected:

    ise::SegmentationContext *m_segContext;
  };

  typedef AbstractFactoryTemplate<RegionBinaryFunction> RegionBinaryFunctionFactory;

}

#endif /* ISEREGIONBINARYFUNCTION_HPP_ */
