/*
  Templated range class.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef RANGE_HPP
#define RANGE_HPP

#include <cassert>

namespace ise {

  template <class T>
  class Range
  {
  public:
    Range()
      : m_min(T()), m_max(T())
    {}

    Range(T inf, T sup)
      : m_min(inf), m_max(sup)
    {
      assert(inf<=sup);
    }

    T min() const
    {
      return m_min;
    }

    T max() const
    {
      return m_max;
    }

    void setMin(T pMin)
    {
      m_min = pMin;
      assert(m_min <= m_max);
    }

    void setMax(T pMax)
    {
      m_max = pMax;
      assert(m_min <= m_max);
    }

    void set(T pMin, T pMax)
    {
      m_min = pMin;
      m_max = pMax;
      assert(m_min <= m_max);
    }

    T width() const 
    {
      return m_max - m_min;
    }

  protected:
    T m_min, m_max;
  };

}

#endif /* ! RANGE_HPP */
