/*
  Quantification non uniform of colors.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * @file iseQuantificationThresholds.hpp
 * @brief non uniform of colors.
 */
#ifndef ISEQUANTIFICATIONTHRESHOLDS_HPP
#define ISEQUANTIFICATIONTHRESHOLDS_HPP

#include <vector>
#include <girl/girlCommon.hpp>
#include <ise/iseConversion.hpp>

#include "iseQuantification.hpp"

namespace ise {

  class GIRL_API QuantificationThresholds : public Quantification
  {
  public:
    
    explicit QuantificationThresholds(SegmentationContext *segContext);

    /**
     * Set thresholds @a thresholds on given channel @a channel of given colorspace @a colorSpaceConversion.
     */
    void setParams(int colorSpaceConversion, 
		   int channel,
		   const std::vector<int> &thresholds);

    void getParams(int &colorSpaceConversion, 
		   int &channel,
		   std::vector<int> &thresholds) const;
    
    void setParams(int colorSpaceConversion, 
		   const std::vector< std::vector<int> > &thresholds);

    /**
     * Set thresholds @a thresholds on several channel of given colorspace @a colorSpaceConversion.
     *
     * channels are considered in increasing order, that is 
     *  thresholds[i] thresholds are applied to channel i, with i in [0; thresholds.size()[.
     *
     * @warning @a thresholds.size() must be inferior or equal to 3.
     */
    void getParams(int &colorSpaceConversion, 
		   std::vector< std::vector<int> > &thresholds) const;
    


    virtual void init(const girl::regionDeque  &/* regions */, int /* level */) {} 

    virtual void init(girl::region /* r */, int /* level */) {}

  protected:

    virtual bool areEquivalentColors(const girl::tools::Pixel &RGBcolor1, 
				     const girl::tools::Pixel &RGBcolor2);

  protected:
    std::vector< std::vector<int> > m_thresholds;
    int m_channel;
    int m_colorSpace;
    ise::conversion::PFConversion *m_colorSpaceConversionFct;
  };
    

}

#endif /* ! ISEQUANTIFICATIONTHRESHOLDS_HPP */
