/*
  Quantification non uniform of colors.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "iseQuantificationThresholds.hpp"

#include <limits>

using namespace ise;

QuantificationThresholds::QuantificationThresholds(SegmentationContext *segContext)
  : 
  Quantification(segContext),
  m_thresholds(),
  m_channel(0),
  m_colorSpace(ISE_RGB_to_RGB),
  m_colorSpaceConversionFct(ise::conversion::changeSpace(m_colorSpace)+m_channel)
{
  
}

void
QuantificationThresholds::setParams(int colorSpaceConversion, 
				    int chan,
				    const std::vector<int> &thresholds)
{
#ifndef NDEBUG
  //- check that thresholds are in increasing order.
  for (size_t i=1; i<thresholds.size(); ++i) //start from 1
    assert(thresholds[i] > thresholds[i-1]);
#endif

  /* //B: false ???
  m_thresholds.resize(1);
  m_thresholds[0] = thresholds;
  */
  assert(chan < 3);
  m_thresholds.clear();
  m_thresholds.resize(chan+1);
  m_thresholds[chan] = thresholds;
    

  m_channel = chan;
  m_colorSpace = colorSpaceConversion;
  m_colorSpaceConversionFct = ise::conversion::changeSpace(colorSpaceConversion)+chan;
}

void
QuantificationThresholds::getParams(int &colorSpaceConversion, 
				    int &channel,
				    std::vector<int> &thresholds) const
{
  assert(! m_thresholds.empty());
  /* //B : false ???
  thresholds = m_thresholds[0];  
  */
  assert(static_cast<size_t>(m_channel) < m_thresholds.size());
  thresholds = m_thresholds[m_channel];

  colorSpaceConversion = m_colorSpace;
  channel = m_channel;
}
    
void
QuantificationThresholds::setParams(int colorSpaceConversion, 
				    const std::vector< std::vector<int> > &thresholds)
{
  m_thresholds = thresholds;
  m_channel = thresholds.size(); //invalid value on purpose
  m_colorSpace = colorSpaceConversion;
  m_colorSpaceConversionFct = ise::conversion::changeSpace(colorSpaceConversion);
}

void
QuantificationThresholds::getParams(int &colorSpaceConversion, 
				    std::vector< std::vector<int> > &thresholds) const
{
  thresholds = m_thresholds;
  colorSpaceConversion = m_colorSpace;
}
 

bool
QuantificationThresholds::areEquivalentColors(const girl::tools::Pixel &c1, 
					      const girl::tools::Pixel &c2)
{
  /*
  if (m_channel < thresholds.size()) {
    //case one channel
    
    assert(m_thresholds.size() == 1);
    ise::conversion::PFConversion colorSpaceConversionFct = *m_colorSpaceConversionFct;
    const int v1 = colorSpaceConversionFct(c1.a(), c1.b(), c1.c());
    const int v2 = colorSpaceConversionFct(c2.a(), c2.b(), c2.c());

    const std::vector<int> &thresholds = m_thresholds[0];
    int level1, level2;
    level1 = level2 = std::numeric_limits<int>::min(); //ise::conversion::absoluteMin(colorSpaceConversion, chan);
    for (size_t i=0; i<thresholds.size(); ++i) {
      if (v1 > thresholds[i])
	level1 = thresholds[i];
      if (v2 > thresholds[i])
	level2 = thresholds[i];
    }
    return level1 == level2;
  }
  */

  assert(m_thresholds.size() <= 3);
  for (size_t k=0; k<m_thresholds.size(); ++k) {
    
    const std::vector<int> &thresholds = m_thresholds[k];
    if (! thresholds.empty()) {
      ise::conversion::PFConversion colorSpaceConversionFct = m_colorSpaceConversionFct[k];
      const int v1 = colorSpaceConversionFct(c1.a(), c1.b(), c1.c());
      const int v2 = colorSpaceConversionFct(c2.a(), c2.b(), c2.c());
      
      int level1, level2;
      level1 = level2 = std::numeric_limits<int>::min();
      for (size_t i=0; i<thresholds.size(); ++i) {
	if (v1 > thresholds[i])
	  level1 = thresholds[i];
	if (v2 > thresholds[i])
	  level2 = thresholds[i];
      }
      if (level1 != level2)
	return false;
    }
  }
  return true;
}
