/*
  Histogram thresholds computer: Otsu method.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseQuantificationThresholderOtsu.hpp"

#include <cmath>
#include "iseHistogram1D.hpp"
#include <iostream>

using namespace ise;
   

void
QuantificationThresholderOtsu::getThresholds(const Histogram1D &h, 
					     std::vector<double> &thresholds)
{
  
  Histogram1D histo = h; //copy
  const size_t sz = histo.size();

  //set min and max values to 0   (//B: was: // set white and black values to 0)
  histo[0] = 0;
  histo[sz-1] = 0;

  std::vector<double> J(sz);
  
  std::vector<double> m1(sz);
  std::vector<double> m2(sz);
  std::vector<double> o1(sz);
  std::vector<double> o2(sz);
  
  double tmp = 0;
  size_t k = 0;

  // compute the new size of picture
  double size = 0;
  for (size_t i = 0; i < sz; ++i)
    size += histo[i];
  const double inv_size = 1.0 / size;

  for (size_t i = 0; i < sz; ++i) {
    double p1 = 0;
    for (size_t v = 0; v < (i+1); ++v)
      p1 += histo[v];
    if (p1 == 0)
      continue; //B
    p1 *= inv_size;
    const double inv_p1 = 1.0 / p1;

    m1[i] = 0;
    for (size_t v = 0; v < (i+1); ++v)
      m1[i] += (v+1)*histo[v];
    m1[i] *= inv_size;
    m1[i] *= inv_p1;

    o1[i] = 0;
    for (size_t v = 0; v < (i+1); ++v)
      o1[i] += ((v+1) - m1[i])*((v+1) - m1[i])*histo[v];
    o1[i] *= inv_size;
    o1[i] *= inv_p1;

    double p2 = 0;
    for (size_t v = (i+1); v < sz; ++v)
      p2 += histo[v];
    if (p2 == 0)
      continue; //B
    p2 *= inv_size;
    const double inv_p2 = 1.0 / p2;

    m2[i] = 0;
    for (size_t v = (i+1); v < sz; ++v)
      m2[i] += (v+1)*histo[v];
    m2[i] *= inv_size;
    m2[i] *= inv_p2;

    o2[i] = 0;
    for (size_t v = (i+1); v < sz; ++v)
      o2[i] += ((v+1) - m2[i])*((v+1) - m2[i])*histo[v];
    o2[i] *= inv_size;
    o2[i] *= inv_p2;
  
    J[i] = (p1*p2*(m1[i]-m2[i])*(m1[i]-m2[i]))/(p1*o1[i]+p2*o2[i]);
  }


  for (size_t v=1; v<sz-1; ++v) {
    if (tmp < J[v]) { 
      k=v; 
      tmp=J[v];  
    }
  }

  thresholds.resize(1);
  thresholds[0] = histo.indexToKey(k);
  
  // const double sig1 = sqrt(o1[k]);
  // const double sig2 = sqrt(o2[k]);

  // const double mu1 = m1[k];
  // const double mu2 = m2[k];  

  // const double Th1 =  histo.indexToKey(mu1 + (sig1 * m_sigma1coeff));
  // const double Th2 =  histo.indexToKey(mu2 - (sig2 * m_sigma2coeff));


  // thresholds.resize(2);
  // thresholds[0] = Th1;
  // thresholds[1] = Th2;
}

size_t
QuantificationThresholderOtsu::getNumberOfThresholds() const
{
  return 1;
}
