/*
  Histogram thresholds computer: mean method.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseQuantificationThresholderMeanPlusTwoStdDev.hpp"

#include <cmath>
#include "iseHistogram1D.hpp"
#include "iseSparseHistogram1D.hpp"

#include <iostream>

using namespace ise;


void
QuantificationThresholderMeanPlusTwoStdDev::getThresholds(const Histogram1D &h, std::vector<double> &thresholds)
{
  const double mean = h.getMean();
  const double stddev = h.getStandardDeviation(mean);

  thresholds.resize(1);
  thresholds[0] = std::min(mean+2*stddev, h.absoluteMax());
}

void
QuantificationThresholderMeanPlusTwoStdDev::getThresholds(const SparseHistogram1DD &h, std::vector<double> &thresholds)
{
  const double mean = h.getMean();
  const double stddev = h.getStandardDeviation(mean);

  thresholds.resize(1);
  thresholds[0] = mean+2*stddev; //std::min(mean+2*stddev, h.absoluteMax());
}

size_t
QuantificationThresholderMeanPlusTwoStdDev::getNumberOfThresholds() const
{
  return 1;
}
