/*
  Histogram thresholds computer base class.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEQUANTIFICATIONTHRESHOLDER_HPP
#define ISEQUANTIFICATIONTHRESHOLDER_HPP

#include <cstddef>//size_t
#include <vector>

namespace ise {

  class Histogram1D;

  class QuantificationThresholder
  {
  public:
    
    virtual ~QuantificationThresholder() {}

    /**
     * @brief Get thresholds @a thresholds computed on histogram @a h.
     */
    virtual void getThresholds(const Histogram1D &h, std::vector<double> &thresholds) = 0;

    /**
     * @brief Get number of thresholds that would be computed by this thresholder, 
     * without actually computing them.
     *
     * If number of computed thresholds is not fixed but dependant of data/histogram, 
     * then (size_t)-1 is returned.
     */
    virtual size_t getNumberOfThresholds() const = 0;

  };

}

#endif /* ! ISEQUANTIFICATIONTHRESHOLDER_HPP */
