/*
  Quantification in a given number of colors.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ISEQUANTIFICATIONNBCOLORS_HPP
#define ISEQUANTIFICATIONNBCOLORS_HPP

#include <girl/girlCommon.hpp>

#include "iseQuantification.hpp"
#include "iseConversion.hpp"
#include "iseColorBinaryTree.hpp"

namespace ise {


  typedef enum {AXIS_CHOICE_VARIANCE=0, AXIS_CHOICE_LENGTH, AXIS_CHOICE_VARIANCE_LENGTH, AXIS_CHOICE_VARIANCE_MEDIAN, AXIS_CHOICE_MSE, AXIS_CHOICE_SPLIT_VARIANCE} QUANTIF_NB_COLOR_AXIS_CHOICE_TYPE;

  typedef enum {CLUSTER_VALUE_WEIGHTED_MSE=0, CLUSTER_VALUE_NON_WEIGHTED_MSE, CLUSTER_VALUE_CARDINAL} QUANTIF_NB_COLOR_CLUSTER_VALUE_TYPE;

  typedef enum {INIT_DEFAULT=0, INIT_DANGEROUS} QUANTIF_NB_COLOR_INIT_TYPE;

  typedef enum {CUT_CHOICE_CUT=0, CUT_CHOICE_CUT_PROJECT, CUT_CHOICE_CUT_MEDIAN, CUT_CHOICE_CUT_MEDIAN_DANGEROUS} QUANTIF_NB_COLOR_CUT_CHOICE_TYPE;


  class GIRL_API QuantificationNbColors : public Quantification
  {
    
  public:
    
    ~QuantificationNbColors();
    
    QuantificationNbColors(SegmentationContext *segContext, int colorSpace = ISE_RGB_to_RGB, int nbColors = 4);
    
    virtual void init(const girl::regionDeque &regions, int level);
    
    virtual void init(girl::region r, int level);
    
    void setParameters(QUANTIF_NB_COLOR_AXIS_CHOICE_TYPE act,
		       QUANTIF_NB_COLOR_CLUSTER_VALUE_TYPE cvt,
		       QUANTIF_NB_COLOR_INIT_TYPE it,
		       QUANTIF_NB_COLOR_CUT_CHOICE_TYPE cct,
		       int colorSpace,
		       int nbColors);

    void getParameters(QUANTIF_NB_COLOR_AXIS_CHOICE_TYPE &act,
		       QUANTIF_NB_COLOR_CLUSTER_VALUE_TYPE &cvt,
		       QUANTIF_NB_COLOR_INIT_TYPE &it,
		       QUANTIF_NB_COLOR_CUT_CHOICE_TYPE &cct,
		       int &colorSpace,
		       int &nbColors) const;
    
  protected :
    
    virtual bool areEquivalentColors(const girl::tools::Pixel &RGBcolor1, 
				     const girl::tools::Pixel &RGBcolor2);
    
    //void addColor(const girl::tools::Pixel &RGBcolor, long frequency);
    
  private:
    QuantificationNbColors(const QuantificationNbColors &);
    QuantificationNbColors &operator=(const QuantificationNbColors &);

  protected:
    ise::ColorBinaryTree m_tree;
    int m_colorSpace;
    int m_nbColors;
    int m_axisChoice;
    int m_clusterValueChoice;
    int m_initChoice;
    int m_cutChoice;
  };

}

#endif /* ! ISEQUANTIFICATIONNBCOLORS_HPP */
