/*
  Quantification in a given number of colors.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseQuantificationNbColors.hpp"

#include "iseHashHistogram.hpp"

#include "iseSegmentationContext.hpp"
#include "iseColorFrequency.hpp"
#include "iseConversion.hpp"

using namespace ise;


QuantificationNbColors::~QuantificationNbColors()
{

}

QuantificationNbColors::QuantificationNbColors(SegmentationContext *segContext, int colorSpace, int nbColors)
  :
  Quantification(segContext),
  m_colorSpace(colorSpace),  
  m_nbColors(nbColors),
  m_axisChoice(0),
  m_clusterValueChoice(0),
  m_initChoice(0),
  m_cutChoice(0)
{

}

namespace {
  class ColorAdder : public girl::toger::pointIterator
  {
  public:
    ColorAdder(ise::SegmentationContext &segC, HashHistogram &histo)
      : m_segC(segC),
	m_histo(histo)
    {

    }

    void processPoint(const girl::point &pt)
    {
      const girl::tools::Pixel p = m_segC.getImage()->getPixel(pt.x(), pt.y());
      m_histo.addColor(p.a(), p.b(), p.c());
    }
  

  protected:
    ise::SegmentationContext &m_segC;
    HashHistogram &m_histo;
  };
}

void 
QuantificationNbColors::init(const girl::regionDeque &regions, int /* level */)
{
  HashHistogram hashTmp;

  ColorAdder ca(*m_segContext, hashTmp);
  girl::regionDeque::const_iterator it = regions.begin();
  const girl::regionDeque::const_iterator itEnd = regions.end();
  for ( ; it != itEnd; ++it) 
    m_segContext->getToger()->iterateOnRegionDomain(*it, ca);
  
  hashTmp.convert(m_colorSpace);
  
  ColorFrequency colFreq(hashTmp);
 
  m_tree.clear();

  m_tree.set(colFreq, 
	     m_clusterValueChoice,
	     m_axisChoice,
	     m_initChoice, 
	     m_cutChoice);
  

  m_tree.createTable(colFreq, m_nbColors, 30.0);


  m_tree.labelLeafes(NULL);
}

/*
void 
QuantificationNbColors::addColor(const girl::tools::Pixel &RGBcolor, long frequency)
{
  m_clusterSet->addColor(RGBcolor, frequency);
}
*/
	       
void QuantificationNbColors::init(girl::region /*r*/, int /*level*/)
{
  /*  HashHistogram hashTmp;

  ColorAdder ca(*m_segContext, hashTmp);
  m_segContext->getToger()->iterateOnRegionDomain(r, ca);
  
  hashTmp.convert(m_colorSpace);
  
  ColorFrequency colFreq(hashTmp);
 
  m_tree.clear();

  m_tree.set(colFreq, 
	     m_clusterValueChoice,
	     m_axisChoice,
	     m_initChoice, 
	     m_cutChoice);

  m_tree.createTable(colFreq, m_nbColors, 30.0);

  m_tree.labelLeafes(NULL);
  */

}

bool
QuantificationNbColors::areEquivalentColors(const girl::tools::Pixel &RGBcolor1, 
					    const girl::tools::Pixel &RGBcolor2)
{
  int color1[3];
  int color2[3];

  conversion::PFConversion *conv = conversion::changeSpace(m_colorSpace);

  color1[0] = conv[0](RGBcolor1.a(), RGBcolor1.b(), RGBcolor1.c());
  color1[1] = conv[1](RGBcolor1.a(), RGBcolor1.b(), RGBcolor1.c());
  color1[2] = conv[2](RGBcolor1.a(), RGBcolor1.b(), RGBcolor1.c());

  color2[0] = conv[0](RGBcolor2.a(), RGBcolor2.b(), RGBcolor2.c());
  color2[1] = conv[1](RGBcolor2.a(), RGBcolor2.b(), RGBcolor2.c());
  color2[2] = conv[2](RGBcolor2.a(), RGBcolor2.b(), RGBcolor2.c());

  int ind1, ind2;
  m_tree.seekColorInTable(color1, ind1);
  m_tree.seekColorInTable(color2, ind2);
  
  if (ind1 == ind2)
    return true;
  return false;
  
}

void 
QuantificationNbColors::setParameters(QUANTIF_NB_COLOR_AXIS_CHOICE_TYPE act,
				      QUANTIF_NB_COLOR_CLUSTER_VALUE_TYPE cvt,
				      QUANTIF_NB_COLOR_INIT_TYPE it,
				      QUANTIF_NB_COLOR_CUT_CHOICE_TYPE cct,
				      int colorSpace,
				      int nbColors)
{
  m_colorSpace = colorSpace;
  m_nbColors = nbColors;
  m_axisChoice = static_cast<int>(act);
  m_clusterValueChoice = static_cast<int>(cvt);
  m_initChoice = static_cast<int>(it);
  m_cutChoice = static_cast<int>(cct);

}

void 
QuantificationNbColors::getParameters(QUANTIF_NB_COLOR_AXIS_CHOICE_TYPE &act,
				      QUANTIF_NB_COLOR_CLUSTER_VALUE_TYPE &cvt,
				      QUANTIF_NB_COLOR_INIT_TYPE &it,
				      QUANTIF_NB_COLOR_CUT_CHOICE_TYPE &cct,
				      int &colorSpace,
				      int &nbColors) const

{
  colorSpace = m_colorSpace;
  nbColors = m_nbColors;
  act = static_cast<QUANTIF_NB_COLOR_AXIS_CHOICE_TYPE>(m_axisChoice);
  cvt = static_cast<QUANTIF_NB_COLOR_CLUSTER_VALUE_TYPE>(m_clusterValueChoice);
  it = static_cast<QUANTIF_NB_COLOR_INIT_TYPE>(m_initChoice);
  cct = static_cast<QUANTIF_NB_COLOR_CUT_CHOICE_TYPE>(m_cutChoice);
}
