/*
  Quantification base class.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEQUANTIFICATION_HPP
#define ISEQUANTIFICATION_HPP

#include <girl/girlCommon.hpp>
#include <girlTools/girlToolsImage.hpp>

#include "iseSegmentationClustering.hpp"


namespace ise {

  class GIRL_API Quantification : public SegmentationClustering
  {
    
  public :

    //Quantification();

    Quantification(SegmentationContext *segContext);


    virtual ~Quantification() {}
  
    //virtual void init(const girl::regionDeque &regions, int level) = 0;
    
    //virtual void init(girl::region r, int level) = 0;


    virtual bool same(const girl::point &p, girl::direction dir);


  protected:  
    
    virtual bool areEquivalentColors(const girl::tools::Pixel &RGBcolor1, 
				     const girl::tools::Pixel &RGBcolor2) = 0;
    

  private:
    Quantification(const Quantification &);
    Quantification &operator=(const Quantification &);

  protected:  
    girl::tools::Pixel m_p1, m_p2;

  };

}


#endif /*ISEQUANTIFICATION_HPP*/
