/*
  Quantification base class.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "iseQuantification.hpp"

#include "iseSegmentationContext.hpp"


using namespace ise;


Quantification::Quantification(SegmentationContext *segContext)
  : SegmentationClustering(segContext), 
    m_p1(), 
    m_p2()
{
  assert(m_segContext && m_segContext->getImage() 
	 && m_segContext->getImage()->channels() <= m_p1.channels() 
	 && m_segContext->getImage()->channels() <= m_p2.channels() );
}

bool 
Quantification::same(const girl::point &p1, girl::direction dir)
{
  /*
  girl::point p2 = p1;
  p2.move(dir);
  
  girl::tools::Image *image = m_segContext->getImage();
  assert(image);

  const girl::tools::Pixel c1 = image->getPixel(p1.x(), p1.y());
  const girl::tools::Pixel c2 = image->getPixel(p2.x(), p2.y());
    
  return areEquivalentColors(c1, c2);
  */

  assert(m_segContext);
  girl::tools::Image *image = m_segContext->getImage();
  assert(image);

  image->getPixelCopy(p1.x(), p1.y(), m_p1);
  girl::point p2 = p1;
  p2.move(dir);
  image->getPixelCopy(p2.x(), p2.y(), m_p2);
  
  return areEquivalentColors(m_p1, m_p2);
}



