/*
  Merge driver meta class.
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEMERGEDRIVERMETA_HPP
#define ISEMERGEDRIVERMETA_HPP

#include "iseMergeDriver.hpp"

#include "iseFactoryTemplate.hxx"
#include "iseRegionStrictWeakOrdering.hpp"
#include "iseRegionUnaryPredicate.hpp"
#include "iseRegionBinaryFunction.hpp"
#include "iseRegionBinaryPredicate.hpp"


namespace ise {

  class GIRL_API MergeDriverMeta : public MergeDriver
  {

  public:

    virtual ~MergeDriverMeta();
    
    explicit MergeDriverMeta(ise::SegmentationContext *segContext);

    virtual void init(const girl::regionDeque &regionsToMerge, int level);
    
    virtual void filter(girl::regionDeque &regionsToMerge, int level);

    virtual void sort(girl::regionDeque &regionsToMerge, int level);

    virtual double distance(girl::region reg1Id, girl::region reg2Id);
    
    virtual bool allowed(girl::region reg1Id, girl::region reg2Id, int level);
    
    virtual girl::region selectCandidate(girl::region regId, int level);
    
    virtual girl::region selectCandidate(girl::region regId, const girl::regionDeque &regions, int level);
    
    /**
     * returns kept region or 0 if regions were not merged
     */
    virtual girl::region execute(girl::region reg1Id, girl::region reg2Id);
    
    

    /*
    void setFilterPredicate(const girl::shared_ptr<RegionUnaryPredicate> &p1)
    {
      m_filterPredicate = p1;
    }

    const girl::shared_ptr<RegionUnaryPredicate> &getFilterPredicate() const
    {
      return m_filterPredicate;
    }
    */

    void setSortPredicate(const girl::shared_ptr<RegionStrictWeakOrdering> &p2)
    {
      m_sortOrdering = p2;
    }

    const girl::shared_ptr<RegionStrictWeakOrdering> &getSortPredicate() const
    {
      return m_sortOrdering;
    }

    void setAllowMergePredicate(const girl::shared_ptr<RegionBinaryPredicate> &p2)
    {
      m_allowMergePredicate = p2;
    }

    const girl::shared_ptr<RegionBinaryPredicate> &getAllowMergePredicate() const
    {
      return m_allowMergePredicate;
    }

    void setDistanceFunction(const girl::shared_ptr<RegionBinaryFunction> &f2)
    {
      m_distanceFunction = f2;
    }
    
    const girl::shared_ptr<RegionBinaryFunction> &getDistanceFunction() const
    {
      return m_distanceFunction;
    }

    
  protected:
    //girl::shared_ptr<RegionUnaryPredicate> m_filterPredicate;
    girl::shared_ptr<RegionStrictWeakOrdering> m_sortOrdering;
    girl::shared_ptr<RegionBinaryPredicate> m_allowMergePredicate;
    girl::shared_ptr<RegionBinaryFunction> m_distanceFunction;
  };

  typedef FactoryTemplate<MergeDriver, MergeDriverMeta> MergeDriverMetaFactory;

}

#endif /* ! ISEMERGEDRIVERMETA_HPP */
