/*
  Merge driver meta implementation.
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseMergeDriverMeta.hpp"

#include <limits>

#include "iseSegmentationContext.hpp"

using namespace ise;


MergeDriverMeta::MergeDriverMeta(ise::SegmentationContext *segContext)
  : MergeDriver(segContext),
    //    m_filterPredicate(),
    m_sortOrdering(),
    m_allowMergePredicate(),
    m_distanceFunction()
{
}

MergeDriverMeta::~MergeDriverMeta()
{

}


void
MergeDriverMeta::init(const girl::regionDeque & /* regionsToMerge */, int /* level */)
{

}

void 
MergeDriverMeta::filter(girl::regionDeque &/* regionsToMerge */, int /* level */)
{
  /*
  if (m_filterPredicate) {
    RegionUnaryPredicate &pred = *m_filterPredicate;

    girl::regionDeque out;
    girl::regionDeque::const_iterator it = regionsToMerge.begin();
    const girl::regionDeque::const_iterator itEnd = regionsToMerge.end();
    for ( ; it != itEnd; ++it) {
      const girl::region r = *it;
      if (pred(r))
	out.push_back(r);
    }
    regionsToMerge = out;
  }
  */
}

struct Sorter
{
  explicit Sorter(girl::shared_ptr<RegionStrictWeakOrdering> swo)
    : m_swo(swo)
  {
    assert(m_swo);
  }

  bool operator()(girl::region r1, girl::region r2)
  {
    return m_swo->operator()(r1, r2);
  }

  girl::shared_ptr<RegionStrictWeakOrdering> m_swo;
};

void
MergeDriverMeta::sort(girl::regionDeque &regionsToMerge, int /* level */)
{
  if (m_sortOrdering) {
    std::sort(regionsToMerge.begin(), regionsToMerge.end(), Sorter(m_sortOrdering));
  }
}

double
MergeDriverMeta::distance(girl::region reg1Id, girl::region reg2Id)
{
  if (GIRL_likely(m_distanceFunction))
    return (*m_distanceFunction)(reg1Id, reg2Id);
  return std::numeric_limits<double>::max();
}

bool
MergeDriverMeta::allowed(girl::region reg1Id, girl::region reg2Id, int /* level */)
{
  if (m_allowMergePredicate)
    return (*m_allowMergePredicate)(reg1Id, reg2Id);
  return false;
}

girl::region
MergeDriverMeta::selectCandidate(girl::region regId, int level)
{
  assert(regId > 0);
  assert(m_segContext);
  assert(m_segContext->getToger());

  girl::regionDeque neighbours;
  m_segContext->getToger()->regionNeighbourhood(regId,  m_neighbourhoodMode, m_neighbourhoodMark, neighbours);
  
  return selectCandidate(regId, neighbours, level);
}

girl::region
MergeDriverMeta::selectCandidate(girl::region regId, const girl::regionDeque &regions, int level)
{
  girl::region selectedRegion = 0;
  double min = std::numeric_limits<double>::max();

  girl::regionDeque::const_iterator it = regions.begin();
  const girl::regionDeque::const_iterator itEnd = regions.end();
  
  for ( ; it != itEnd; ++it) {
    
    const girl::region reg2Id = *it;
    if (allowed(regId, reg2Id, level)) {
      const double dist = distance(regId, reg2Id);
      if (dist < min) {
	selectedRegion = reg2Id;
	min = dist;
      }
    }
  }
  
  return selectedRegion;
}


girl::region
MergeDriverMeta::execute(girl::region reg1Id, girl::region reg2Id)
{
  assert(reg1Id != 0);
  assert(reg2Id != 0);
  assert( m_segContext);
  assert(m_segContext->getToger());
  return m_segContext->getToger()->mergeRegions(reg1Id, reg2Id); 

}
