/*
  Merge driver default implementation.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEMERGEDRIVERDEFAULT_HPP
#define ISEMERGEDRIVERDEFAULT_HPP

#include <girl/girlCommon.hpp>
#include "iseMergeDriver.hpp"


namespace ise {

  class SegmentationContext;

  class GIRL_API MergeDriverDefault : public MergeDriver
  {

  public :

    explicit MergeDriverDefault(ise::SegmentationContext *segContext = NULL)
      : MergeDriver(segContext)
    {}
    
    virtual ~MergeDriverDefault() {}
    
    virtual void init(const girl::regionDeque &regionsToMerge, int level);
    
    virtual void filter(girl::regionDeque &regionsToMerge, int level);


    virtual double distance(girl::region reg1Id, girl::region reg2Id);
    
    virtual bool allowed(girl::region reg1Id, girl::region reg2Id, int level);
    
    virtual girl::region selectCandidate(girl::region regId, int level);
    
    virtual girl::region selectCandidate(girl::region regId, const girl::regionDeque &regions, int level);
    
    //B: returns kept region or 0 if regions were not merged
    virtual girl::region execute(girl::region reg1Id, girl::region reg2Id);
    
//    inline virtual void setParameters(const std::string &regSetUri)
//    {
//      m_regSetUri = regSetUri;
//    }
//
//    inline virtual void getParameters(std::string& regSetUri) const
//    {
//      regSetUri = m_regSetUri;
//    }

    

  };
  
  
}

#endif /* ! ISEMERGEDRIVERDEFAULT_HPP */
