/*
  Merge driver default implementation.
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseMergeDriverDefault.hpp"

#include <cmath>
#include <limits>
#include <algorithm>

#include "iseRegionBinaryFunction.hpp"
//#include "iseRegionSet.hpp"
#include "iseRegionFeatureTools.hpp"
#include "iseSegmentationContext.hpp"


using namespace ise;

void
MergeDriverDefault::init(const girl::regionDeque & /* regionsToMerge */, int /* level */)
{

}

void 
MergeDriverDefault::filter(girl::regionDeque & /* regionsToMerge */, int /* level */)
{
  //std::sort(regionsToMerge.begin(), regionsToMerge.end(), less);
}

double
MergeDriverDefault::distance(girl::region /* reg1Id */, girl::region /* reg2Id */)
{

  double dist = 0.0;
  /*
  std::vector<RegionSetParameters>::const_iterator regSetParamsIt = m_regSetParameters.begin();
  const std::vector<RegionSetParameters>::const_iterator regSetParamsItEnd = m_regSetParameters.end();
  for ( ; regSetParamsIt != regSetParamsItEnd; ++regSetParamsIt) {
    const girl::shared_ptr<RegionSetInterface> regSet = m_segContext->getRegionSet(regSetParamsIt->getUri());
    assert(regSet);
    size_t featureDim = regSet->getFeatureDim();
    std::vector<RegionFeature_Data_Type> region1Data(featureDim);
    ise::RegionFeature region1(&(region1Data[0]));
    regSet->getRegionFeatures(reg1Id, region1);
    std::vector<RegionFeature_Data_Type> region2Data(featureDim);
    ise::RegionFeature region2(&(region2Data[0]));
    regSet->getRegionFeatures(reg2Id, region2);
//    assert(region1);
//    assert(region2);
    // R: TODO, make the distance function parametrizable
//    BinaryFunction mf;
//    double dist = mf(reg1Id, reg2Id);
//    ise::RegionFeatureL2DistSq distComputer(regSet->getFeatureDim());
//    dist += (regSetParamsIt->getWeight())*(region1->dist(distComputer, *region2));
  }
  */
  return dist;
}

bool
MergeDriverDefault::allowed(girl::region /*reg1Id*/, girl::region /*reg2Id*/, int /*level*/)
{
  return true;
}

girl::region
MergeDriverDefault::selectCandidate(girl::region regId, int level)
{
  assert(regId > 0);
  assert(m_segContext);
  assert(m_segContext->getToger());

  girl::regionDeque neighbours;
  m_segContext->getToger()->regionNeighbourhood(regId,  m_neighbourhoodMode, m_neighbourhoodMark, neighbours);
  
  return selectCandidate(regId, neighbours, level);
}

girl::region
MergeDriverDefault::selectCandidate(girl::region regId, const girl::regionDeque &regions, int level)
{
  //REM: keep the algorithm this way, to be able to sub-class MergeDriverDefault & just redifine some handles.

  girl::region selectedRegion = 0;
  double min = std::numeric_limits<double>::max();

  girl::regionDeque::const_iterator it = regions.begin();
  const girl::regionDeque::const_iterator itEnd = regions.end();
  
  for ( ; it != itEnd; ++it) {
    
    const girl::region reg2Id = *it;
    if (allowed(regId, reg2Id, level)) {
      const double dist = distance(regId, reg2Id);
      if (dist < min) {
	selectedRegion = reg2Id;
	min = dist;
      }
    }
  }
  
  return selectedRegion;
}


girl::region
MergeDriverDefault::execute(girl::region reg1Id, girl::region reg2Id)
{
  assert(reg1Id != 0);
  assert(reg2Id != 0);

  /*
  ise::RegionSet *regSet = m_segContext->getRegionSet();
  assert(regSet);

  ise::RegionColorimetricFeatures *region1=NULL, *region2=NULL;
   
  region1 = regSet->getRegionFeatures(reg1Id);
  assert(region1 != NULL);
   
  region2 = regSet->getRegionFeatures(reg2Id);
  assert(region2 != NULL);
   
  girl::region keptRegion = m_segContext->getToger()->mergeRegions(reg1Id, reg2Id); 

  if (keptRegion == reg1Id) {
    region1->merge2RegionFeatures(region2);
    regSet->deleteRegion(reg2Id);
  }
  else {
    assert(keptRegion == reg2Id);
    region2->merge2RegionFeatures(region1);
    regSet->deleteRegion(reg1Id);
  }
     
  return keptRegion;
  */
  //B: BUG !!!
  //B: Don't touch to regSet ! It will be done by callbacks/hooks on toger
  //B: (if we have a delHook and no mergeHook, when we return from toger::mergeRegion
  //B:  the RegionColorimetricFeatures corresponding to deleted region is no longer valid !)


  return m_segContext->getToger()->mergeRegions(reg1Id, reg2Id); 

}
