/*
  Merge driver that merge with the first neighbour.
  Copyright (C) 2012 Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEMERGEDRIVERALWAYS_HPP
#define ISEMERGEDRIVERALWAYS_HPP

#include <girl/girlCommon.hpp>
#include "iseMergeDriver.hpp"


namespace ise {

  class SegmentationContext;

  class GIRL_API MergeDriverAlways : public MergeDriver
  {

  public :

    explicit MergeDriverAlways(ise::SegmentationContext *segContext = NULL)
      : MergeDriver(segContext)
    {}
    
    virtual ~MergeDriverAlways() {}
    
    virtual void init(const girl::regionDeque &regionsToMerge, int level);
    
    virtual void filter(girl::regionDeque &regionsToMerge, int level);

    virtual double distance(girl::region reg1Id, girl::region reg2Id);
    
    virtual bool allowed(girl::region reg1Id, girl::region reg2Id, int level);
    
    virtual girl::region selectCandidate(girl::region regId, int level);
    
    virtual girl::region selectCandidate(girl::region regId, const girl::regionDeque &regions, int level);
    
    virtual girl::region execute(girl::region reg1Id, girl::region reg2Id);
    

  };
  
  
}

#endif /* ! ISEMERGEDRIVERALWAYS_HPP */
