/*
  Merge driver that merge with the first neighbour.
  Copyright (C) 2012 Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseMergeDriverAlways.hpp"

#include <cmath>
#include <limits>
#include <algorithm>

#include "iseRegionBinaryFunction.hpp"
//#include "iseRegionSet.hpp"
#include "iseRegionFeatureTools.hpp"
#include "iseSegmentationContext.hpp"


using namespace ise;

void
MergeDriverAlways::init(const girl::regionDeque & /* regionsToMerge */, int /* level */)
{

}

void 
MergeDriverAlways::filter(girl::regionDeque & /* regionsToMerge */, int /* level */)
{
  
}

double
MergeDriverAlways::distance(girl::region /* reg1Id */, girl::region /* reg2Id */)
{
  return 0.0;
}

bool
MergeDriverAlways::allowed(girl::region /*reg1Id*/, girl::region /*reg2Id*/, int /*level*/)
{
  return true;
}

girl::region
MergeDriverAlways::selectCandidate(girl::region regId, int /*level*/)
{
  assert(regId > 0);
  assert(m_segContext);
  assert(m_segContext->getToger());
  
  return m_segContext->getToger()->anyRegionNeighbour(regId, m_neighbourhoodMode, m_neighbourhoodMark);
}

girl::region
MergeDriverAlways::selectCandidate(girl::region /*regId*/, const girl::regionDeque &regions, int /*level*/)
{
  if (! regions.empty())
    return *(regions.begin());
  return 0;
}

girl::region
MergeDriverAlways::execute(girl::region reg1Id, girl::region reg2Id)
{
  assert(reg1Id != 0);
  assert(reg2Id != 0);
  assert(m_segContext->getToger());

  return m_segContext->getToger()->mergeRegions(reg1Id, reg2Id);
}
