/*
  Merge driver base class.
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEMERGEDRIVER_HPP
#define ISEMERGEDRIVER_HPP

#include <string>
#include <vector>

#include <girl/girlToger.hpp>

#include "iseRegionSetParameters.hpp"
#include "iseAbstractFactoryTemplate.hxx"

namespace ise {

  class SegmentationContext;

  class GIRL_API MergeDriver
  {

  public:

    MergeDriver(ise::SegmentationContext *segContext)
      : m_segContext(segContext),
  //      m_regSetUris(),
        m_regSetParameters(),
	m_neighbourhoodMode(girl::toger::NEIGHBOUR_ANY),
	m_neighbourhoodMark(girl::toger::MARK_NONE)
    { 

    }

    virtual ~MergeDriver() {}


    virtual ise::SegmentationContext *getSegContext() const 
    { 
      return m_segContext; 
    }

    virtual void setSegContext(ise::SegmentationContext *s) 
    { 
      m_segContext = s; 
    }


    virtual void setNeighbourhood(girl::toger::neighbouringModes mode, 
				  girl::toger::markFlags mark)
    {
      m_neighbourhoodMode = mode;
      m_neighbourhoodMark = mark;
    }

    virtual void getNeighbourhood(girl::toger::neighbouringModes &mode, 
				  girl::toger::markFlags &mark)
    {
      mode = m_neighbourhoodMode;
      mark = m_neighbourhoodMark;
    }

//    void getRegSetUris(std::vector<std::string> &uri) const
//    {
//      std::vector<RegionSetParameters>::const_iterator it = m_regSetParameters.begin();
//
//      uri = m_regSetUris;
//    }

//    void setRegSetUris(const std::vector<std::string> &uri)
//    {
//      m_regSetUris = uri;
//    }

    void getRegSetParameters(std::vector<RegionSetParameters> &params) const
    {
      params = m_regSetParameters;
    }

    void setRegSetParameters(const std::vector<RegionSetParameters> &params)
    {
      m_regSetParameters = params;
    }

    virtual void init(const girl::regionDeque &regionsToMerge, int level)=0;

    virtual bool less(girl::region r1, girl::region r2)
    {
      return r1<r2;
    }

    virtual void filter(girl::regionDeque &regionsToMerge, int level) = 0;

    /**
     * @brief Return distance between two regions @a reg1Id and @a reg2Id.
     *
     * For example this method could be used in
     * - allowed() to decide if merge is possible
     * - selectCandidate() to choose the closest region as candidate
     * ...
     */
    virtual double distance(girl::region reg1Id, girl::region reg2Id) = 0;

    /**
     * @brief Tell if merge between two regions @a reg1Id and @a reg2Id is possible.
     */
    virtual bool allowed(girl::region reg1Id, girl::region reg2Id, int level) = 0;
    
    /**
     * @brief Return best candidate to merge with region @a regId.
     *
     * For example, candidate could be chosen among direct neighbours of @a regId.
     */
    virtual girl::region selectCandidate(girl::region regId, int level) = 0;

    /**
     * @brief Return best candidate to merge with region @a regId chosen among @a regions.
     */
    virtual girl::region selectCandidate(girl::region regId, const girl::regionDeque &regions, int level) = 0;

    /**
     * @brief Do the actual merge between two regions @a reg1Id and @a reg2Id.
     */
    virtual girl::region execute(girl::region reg1Id, girl::region reg2Id) = 0;


  public:
    

  public:

  private:
    MergeDriver(const MergeDriver &);
    MergeDriver &operator=(const MergeDriver &);
    

  protected:
    ise::SegmentationContext *m_segContext;

//    std::vector<std::string>         m_regSetUris;
    std::vector<RegionSetParameters> m_regSetParameters;

    girl::toger::neighbouringModes m_neighbourhoodMode;
    girl::toger::markFlags         m_neighbourhoodMark;

  };

  typedef AbstractFactoryTemplate<MergeDriver> MergeDriverFactory;

}

#endif /* ! ISEMERGEDRIVER_HPP */
