/*
  Merge algorithm default implementation that merges until is is not possible anymore.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEMERGEALGORITHMUNTIL_HPP
#define ISEMERGEALGORITHMUNTIL_HPP

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>

#include "iseMergeAlgorithmDefault.hpp"

namespace ise {

  class SegmentationContext;

  class GIRL_API MergeAlgorithmUntil: public MergeAlgorithmDefault
  {

  public:
    explicit MergeAlgorithmUntil(ise::SegmentationContext *segContext)
      : MergeAlgorithmDefault(segContext) 
    {}
    
    virtual ~MergeAlgorithmUntil() {}
    
    virtual void apply(girl::regionDeque &regionsToMerge,
		       ise::MergeDriver &driver,
		       int level,
		       girl::regionDeque &keptRegions);

  };
}

#endif /*  ISEMERGEALGORITHMUNTIL_HPP */
