/*
  Merge algorithm implementation that merges until is is not possible anymore.
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "iseMergeAlgorithmUntil.hpp"

#include <algorithm>

#include <girl/girlHashMap.hpp>
#include <girl/girlHashFunc.hpp>

#include "iseMergeDriver.hpp"
//#include "iseRegionSet.hpp"
#include "iseSegmentationContext.hpp"
#include "iseRegionColorimetricFeatures.hpp"
#include "iseRegionTools.hpp"

using namespace ise;

#ifndef NDEBUG
static
bool
P_checkRegionsValidity(const ise::SegmentationContext * /*segContext*/,
    const girl::regionDeque &/*regions*/,
    const ise::MergeDriver &/*driver*/)
{

 // //  ise::RegionSet *regSet = segContext->getRegionSet();
//  std::vector<ise::RegionSetParameters> regSetParams;
//  driver.getRegSetParameters(regSetParams);
//  std::vector<ise::RegionSetParameters>::const_iterator it = regSetParams.begin();
//  const std::vector<ise::RegionSetParameters>::const_iterator itEnd = regSetParams.end();
//  for ( ; it != itEnd; ++it) {
//    const girl::shared_ptr<ise::RegionSetInterface> regSet = segContext->getRegionSet(it->getUri());
//    if (regSet) {
//      for (girl::regionDeque::const_iterator it = regions.begin();
//          it != regions.end();
//          ++it) {
//        if (regSet->getRegionFeatures(*it) == NULL) {
//          std::cerr<<"region "<<*it<<" has no region feature !!!!!"<<std::endl;
//          return false;
//        }
//      }
//    } else {
//      std::cerr << "Unknow Region Feature Requested!!!! " << it->getUri() << std::endl;
//      return false;
//    }
//  }

  return true;
}
#endif //NDEBUG

void
MergeAlgorithmUntil::apply(girl::regionDeque &regionsToMerge,
    ise::MergeDriver &driver,
    int level,
    girl::regionDeque &keptRegions)
{

  driver.init(regionsToMerge, level);

  size_t numMerges = 0;

  do {

    assert(P_checkRegionsValidity(m_segContext, regionsToMerge, driver));

    keptRegions.clear();

    //std::cerr<<"MergeAlgorithmUntil::apply() : regionsToMerge.size()="<<regionsToMerge.size();

    numMerges = MergeAlgorithmDefault::apply_aux(regionsToMerge, driver, level, keptRegions);

    //std::cerr<<" keptRegions.size()="<<keptRegions.size()<<" numMerges="<<numMerges<<"\n";

    std::swap(regionsToMerge, keptRegions); //regionsToMerge = keptRegions;

    assert(P_checkRegionsValidity(m_segContext, keptRegions, driver));

  }
  while (numMerges != 0);

}
