/*
  Merge algorithm base class.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEMERGEALGORITHM_HPP
#define ISEMERGEALGORITHM_HPP

#include <girl/girlToger.hpp>

namespace ise {

  class SegmentationContext;
  class MergeDriver;

  class MergeAlgorithm 
  {

  public:
    MergeAlgorithm(ise::SegmentationContext *segContext)
      : m_segContext(segContext)
    {}
    
    virtual ~MergeAlgorithm() {}
    
    virtual ise::SegmentationContext *getSegContext() const 
    { 
      return m_segContext; 
    }

    virtual void setSegContext(ise::SegmentationContext *s) 
    { 
      m_segContext = s; 
    }


    virtual void apply(girl::regionDeque &regionsToMerge,
		       ise::MergeDriver &driver,
		       int level,
		       girl::regionDeque &keptRegions) = 0;

  private:
    MergeAlgorithm(const MergeAlgorithm &);
    MergeAlgorithm &operator=(const MergeAlgorithm &);

  protected:

    SegmentationContext *m_segContext;
  };
}

#endif /*  ISEMERGEALGORITHM_HPP */
