/*
  Copyright (C) 2005-2011 Vieux Remi, Boris Mansencal  remi.vieux@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef IMAGELABELTOGER_HPP
#define IMAGELABELTOGER_HPP

#include <opencv2/core/core.hpp>
#include <girl/girlToger.hpp>

namespace ise{

  class GIRL_API ImageLabelToger : public girl::toger::pointIterator
  {
  public:
    ImageLabelToger(int width = 1, int height = 1) :
      m_mat(height, width, CV_32S, cv::Scalar(-1,-1,-1, -1)),
      m_regId(0)
	{
	}

    virtual
      ~ImageLabelToger() {}

    virtual void setRegId(const girl::region &id) { m_regId = id; }

    virtual void processPoint(const girl::point &p)
    {
      assert(p.x() >= 0 && p.x() < m_mat.cols && p.y() >= 0 && p.y() < m_mat.rows);
      m_mat.at<int>(p.y(), p.x()) = m_regId;
    }

    bool belongsTo(const girl::point &p, const girl::region &regionId) const
    {
      assert(m_mat.rows && m_mat.cols);
      assert(p.x() >= 0 && p.x() < m_mat.cols && p.y() >= 0 && p.y() < m_mat.rows);
      return m_mat.at<int>(p.y(), p.x()) == regionId;
    }

    int regionId(const girl::point &p) const
    {
      assert(p.x() >= 0 && p.x() < m_mat.cols && p.y() >= 0 && p.y() < m_mat.rows);
      return m_mat.at<int>(p.y(), p.x());
    }
    
  private:
    cv::Mat m_mat;
    girl::region m_regId;
  };
}

#endif /* ! IMAGELABELTOGER_HPP */
