/*
  Copyright (C) 2005-2010 Vieux Remi, Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEIMAGEFEATURETHRESHOLD_HPP
#define ISEIMAGEFEATURETHRESHOLD_HPP

#include <vector>

#include <girl/girlCommon.hpp>
#include <girlTools/girlToolsImageFeature.hpp>

#include "iseFactoryTemplate.hxx"
#include "iseImageFeatureBinaryComputer.hpp"
#include "iseSegmentationContext.hpp"


namespace ise {

  class GIRL_API ImageFeatureThreshold : public ise::ImageFeatureBinaryComputer
  {
    static const size_t FEATURE_DIMENSION = 1;

  public:
    explicit ImageFeatureThreshold(ise::SegmentationContext *segC);
    
    virtual ~ImageFeatureThreshold()
    {
    }

    virtual void compute();
    
    virtual void setParameters(std::vector<int> levels, int colorSpace, int channel);

    virtual void getParameters(std::vector<int> &levels, int &colorSpace, int &channel) const;

    virtual const std::string uri() const;

    virtual const std::string baseUri() const;

    void
    getDimDescription(std::vector<std::string> &dimDesc) const;

    size_t
    getFeatureDim() const { return FEATURE_DIMENSION; }

    void
    getRequiredComputers(FeatureComputer::FeatureComputerListType&) const {}

  private:
    ImageFeatureThreshold(const ImageFeatureThreshold&);
    ImageFeatureThreshold &operator=(const ImageFeatureThreshold&);
    
  private:
    
    std::vector<int> m_levels;
    int m_colorSpace;
    int m_channel;
  };

  typedef FactoryTemplate<ImageFeatureComputer, ImageFeatureThreshold> ImageFeatureThresholdFactory;
}
#endif /* ! ISEIMAGEFEATURETHRESHOLD_HPP */
