/*
  Copyright (C) 2005-2010 Vieux Remi, Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseImageFeatureThreshold.hpp"

using namespace ise;

ImageFeatureThreshold::ImageFeatureThreshold(ise::SegmentationContext *segC)
  : ImageFeatureBinaryComputer(segC)
  , m_levels()
  , m_colorSpace(0)
  , m_channel(0)
{
}

const std::string
ImageFeatureThreshold::baseUri() const
{
  return "Threshold";
}

const std::string
ImageFeatureThreshold::uri() const
{
  std::stringstream ss(std::ios::in|std::ios::out);
  ss<<baseUri();
  size_t size = m_levels.size();
  for (size_t i = 0 ; i < size ; ++i) 
    ss<< IMAGE_FEATURE_URI_SEPARATOR<<m_levels[i];
  ss<<IMAGE_FEATURE_URI_SEPARATOR<<m_colorSpace<<IMAGE_FEATURE_URI_SEPARATOR<<m_channel;
  return ss.str();
}

void
ImageFeatureThreshold::compute()
{
  assert(m_segContext);
  assert(m_segContext->getImage());
  assert(m_levels.size() == static_cast<size_t>(DIM));

  const girl::tools::Image *img = m_segContext->getImage();

  const int width = img->width(); 
  const int height = img->height();
  
  m_imgF = girl::shared_ptr<girl::tools::ImageFeature>(new girl::tools::ImageFeature(width, height, DIM));
  
  for ( int j = 0 ; j < height ; ++j) {
    const girl::tools::Image::type *imgBuf = img->scanLine(j);
    girl::tools::ImageFeature::type *imgfBuf = m_imgF->scanLine(j);

    for (int i = 0 ; i < width ; ++i) {
      girl::tools::ImageFeature::type a;
      
      ise::conversion::PFConversion *m_conversion = ise::conversion::changeSpace(m_colorSpace);

      a = m_conversion[m_channel](imgBuf[0], imgBuf[1], imgBuf[2]);
      a > m_levels[0] ? a = GMAX : a = GMIN;
      *imgfBuf = a;
      
      imgBuf += img->formatSize();
      imgfBuf += m_imgF->formatSize();
    }
  }
}

void
ImageFeatureThreshold::setParameters(std::vector<int> levels, int colorSpace, int channel)
{
  m_levels = levels;
  m_colorSpace = colorSpace;
  m_channel = channel;
}

void
ImageFeatureThreshold::getParameters(std::vector<int> &levels, int &colorSpace, int &channel) const 
{
  levels = m_levels;
  colorSpace = m_colorSpace;
  channel = m_channel;
}

void 
ImageFeatureThreshold::getDimDescription(std::vector<std::string> &dimDesc) const
{
  dimDesc.clear();
  std::stringstream ss;
  ss << "Threshold "<<m_colorSpace<<" "<<m_channel<<" "<<m_levels[0];
  dimDesc.push_back(ss.str());
}
